/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.job.tasklet;

import com.humuson.tms.batch.domain.CustomQueueTableRow;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class DeleteQueueTableCheckTasklet
implements Tasklet {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private String selectQueueTableIdSql;
    private String deleteQueueTableRecords;
    @Value(value="#{config['use.delete.queue.table']}")
    protected boolean useDeleteQueueTable;
    @Value(value="#{config['delete.queue.table.list']}")
    protected String queueTables;
    @Value(value="#{config['delete.queue.table.cycle']}")
    protected int cycle;
    Logger logger = LoggerFactory.getLogger(DeleteQueueTableCheckTasklet.class);

    public RepeatStatus execute(StepContribution stepContribution, ChunkContext chunkContext) throws Exception {
        if (!this.useDeleteQueueTable) {
            return RepeatStatus.FINISHED;
        }
        String[] queueTableList = this.queueTables.split(",");
        if (queueTableList.length < 1) {
            this.logger.info("Not found queue table list in env file.");
            return RepeatStatus.FINISHED;
        }
        List list = null;
        String query = null;
        for (int i = 0; i < queueTableList.length; ++i) {
            this.logger.info("Queue table delete for : {}", (Object)queueTableList[i]);
            do {
                list = new ArrayList();
                query = this.selectQueueTableIdSql.replace("@QUEUE_TABLE@", queueTableList[i]);
                this.logger.debug("SELECT QUERY : {}", (Object)query);
                list = this.jdbcTemplate.query(query, (RowMapper)new CustomQueueTableRowMapper(), new Object[]{this.cycle});
                ArrayList<Object[]> seqParams = new ArrayList<Object[]>();
                for (CustomQueueTableRow row : list) {
                    seqParams.add(new Object[]{row.getSeq()});
                }
                this.logger.info("delete queue table start [size:{}]", (Object)list.size());
                query = this.deleteQueueTableRecords.replace("@QUEUE_TABLE@", queueTableList[i]);
                this.logger.debug("DELETE QUERY : {}", (Object)query);
                try {
                    this.jdbcTemplate.batchUpdate(query, seqParams);
                }
                catch (Exception e) {
                    this.logger.error("delete queue table error", (Throwable)e);
                    for (Object[] param : seqParams) {
                        try {
                            this.jdbcTemplate.update(query, param);
                        }
                        catch (Exception e2) {
                            this.logger.error("delete queue table error skip param [seq:{}]", param[0]);
                        }
                    }
                }
            } while (!list.isEmpty());
        }
        return RepeatStatus.FINISHED;
    }

    public void setSelectQueueTableIdSql(String selectQueueTableIdSql) {
        this.selectQueueTableIdSql = selectQueueTableIdSql;
    }

    public void setDeleteQueueTableRecords(String deleteQueueTableRecords) {
        this.deleteQueueTableRecords = deleteQueueTableRecords;
    }

    public class CustomQueueTableRowMapper
    implements RowMapper<CustomQueueTableRow> {
        public CustomQueueTableRow mapRow(ResultSet rs, int rownum) throws SQLException {
            CustomQueueTableRow bean = new CustomQueueTableRow();
            bean.setSeq(rs.getLong("SEQ"));
            return bean;
        }
    }
}

