/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.job.tasklet;

import com.humuson.tms.common.util.FatigueListTableNameUtil;
import com.humuson.tms.constrants.ChannelType;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

public class DeleteFatigueListTasklet
implements Tasklet {
    private static final Logger log = LoggerFactory.getLogger(DeleteFatigueListTasklet.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private String truncateFatigueListSql;
    private final String TABLE_NAME = "@@TABLE_NAME@@";
    private final String PARTITION_NAME = "@@PARTITION_NAME@@";
    private final String PARTITION_PREFIX_NAME = "P_FATIGUE_";

    public RepeatStatus execute(StepContribution stepContribution, ChunkContext chunkContext) throws Exception {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        String yearMonth = null;
        if (month == 1) {
            --year;
            month = 12;
        } else {
            --month;
        }
        yearMonth = month < 10 ? year + "0" + month : year + "" + month;
        try {
            log.info("Truncate fatigue list start");
            String sql = null;
            String tableName = null;
            String partitionName = null;
            for (ChannelType chn : ChannelType.values()) {
                sql = this.truncateFatigueListSql;
                tableName = FatigueListTableNameUtil.getFatigueListTableName((String)chn.getCode());
                if (tableName == null) continue;
                if (chn.getCode().equals(ChannelType.LMS.getCode())) continue;
                partitionName = chn.getCode().equals("KA") ? "P_FATIGUE_KAKAO_" + yearMonth : "P_FATIGUE_" + chn.getName() + "_" + yearMonth;
                sql = sql.replace("@@TABLE_NAME@@", tableName);
                sql = sql.replace("@@PARTITION_NAME@@", partitionName);
                int count = this.jdbcTemplate.update(sql);
                log.info("Truncate Success ChannelType : {} / Partition Table : {} Partition Name : {}", new Object[]{chn.getCode(), tableName, partitionName});
            }
            log.info("Truncate fatigue list end");
        }
        catch (Exception e) {
            log.error("delete fatigue list error", (Throwable)e);
        }
        return RepeatStatus.FINISHED;
    }

    public void setTruncateFatigueListSql(String truncateFatigueListSql) {
        this.truncateFatigueListSql = truncateFatigueListSql;
    }
}

