/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.job.tasklet;

import com.humuson.tms.batch.domain.BatchJobExeRow;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class DeleteBatchScheduleCheckTasklet
implements Tasklet {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private String selectJobInstanceIdSql;
    private String deleteBatchJobExecutionContext;
    private String deleteBatchJobExecutionParam;
    private String deleteBatchJobExecution;
    private String deleteBatchJobInstance;
    private String deleteStepExecutionContext;
    private String deleteStepExecution;
    Logger logger = LoggerFactory.getLogger(DeleteBatchScheduleCheckTasklet.class);

    public RepeatStatus execute(StepContribution stepContribution, ChunkContext chunkContext) throws Exception {
        List list = new ArrayList();
        do {
            list = this.jdbcTemplate.query(this.selectJobInstanceIdSql, (RowMapper)new BatchJobRowMapper());
            ArrayList<Object[]> jobExecutionIdParams = new ArrayList<Object[]>();
            ArrayList<Object[]> jobInstanceIdParams = new ArrayList<Object[]>();
            for (BatchJobExeRow row : list) {
                jobExecutionIdParams.add(new Object[]{row.getJobExecutionId()});
                jobInstanceIdParams.add(new Object[]{row.getJobInstanceId()});
            }
            this.logger.info("deleteStepExecutionContext start [size:{}]", (Object)list.size());
            try {
                this.jdbcTemplate.batchUpdate(this.deleteStepExecutionContext, jobExecutionIdParams);
            }
            catch (Exception e) {
                this.logger.error("deleteStepExecutionContext error", (Throwable)e);
                for (Object[] param : jobExecutionIdParams) {
                    try {
                        this.jdbcTemplate.update(this.deleteStepExecutionContext, param);
                    }
                    catch (Exception e2) {
                        this.logger.error("deleteStepExecutionContext error skip param[jobExcutionId:{}]", param[0]);
                    }
                }
            }
            this.logger.info("deleteBatchJobExecutionContext start [size:{}]", (Object)list.size());
            try {
                this.jdbcTemplate.batchUpdate(this.deleteBatchJobExecutionContext, jobExecutionIdParams);
            }
            catch (Exception e) {
                this.logger.error("deleteBatchJobExecutionContext error", (Throwable)e);
                for (Object[] param : jobExecutionIdParams) {
                    try {
                        this.jdbcTemplate.update(this.deleteBatchJobExecutionContext, param);
                    }
                    catch (Exception e2) {
                        this.logger.error("deleteBatchJobExecutionContext error skip param[jobExcutionId:{}]", param[0]);
                    }
                }
            }
            this.logger.info("deleteStepExecution start [size:{}]", (Object)list.size());
            try {
                this.jdbcTemplate.batchUpdate(this.deleteStepExecution, jobExecutionIdParams);
            }
            catch (Exception e) {
                this.logger.error("deleteStepExecution error", (Throwable)e);
                for (Object[] param : jobExecutionIdParams) {
                    try {
                        this.jdbcTemplate.update(this.deleteStepExecution, param);
                    }
                    catch (Exception e2) {
                        this.logger.error("deleteStepExecution error skip param[jobExcutionId:{}]", param[0]);
                    }
                }
            }
            this.logger.info("deleteBatchJobExecutionParam start [size:{}]", (Object)list.size());
            try {
                this.jdbcTemplate.batchUpdate(this.deleteBatchJobExecutionParam, jobExecutionIdParams);
            }
            catch (Exception e) {
                this.logger.error("deleteBatchJobExecutionParam error", (Throwable)e);
                for (Object[] param : jobExecutionIdParams) {
                    try {
                        this.jdbcTemplate.update(this.deleteBatchJobExecutionParam, param);
                    }
                    catch (Exception e2) {
                        this.logger.error("deleteBatchJobExecutionParam error skip param[jobExcutionId:{}]", param[0]);
                    }
                }
            }
            this.logger.info("deleteBatchJobExecution start [size:{}]", (Object)list.size());
            try {
                this.jdbcTemplate.batchUpdate(this.deleteBatchJobExecution, jobExecutionIdParams);
            }
            catch (Exception e) {
                this.logger.error("deleteBatchJobExecution", (Throwable)e);
                for (Object[] param : jobExecutionIdParams) {
                    try {
                        this.jdbcTemplate.update(this.deleteBatchJobExecution, param);
                    }
                    catch (Exception e2) {
                        this.logger.error("deleteBatchJobExecution error skip param[jobExcutionId:{}]", param[0]);
                    }
                }
            }
            this.logger.info("deleteBatchJobInstance start [size:{}]", (Object)list.size());
            try {
                this.jdbcTemplate.batchUpdate(this.deleteBatchJobInstance, jobInstanceIdParams);
            }
            catch (Exception e) {
                this.logger.error("deleteBatchJobInstance error ", (Throwable)e);
                for (Object[] param : jobInstanceIdParams) {
                    try {
                        this.jdbcTemplate.update(this.deleteBatchJobInstance, param);
                    }
                    catch (Exception e2) {
                        this.logger.error("deleteBatchJobInstance error skip param[jobExcutionId:{}]", param[0]);
                    }
                }
            }
        } while (!(list = new ArrayList()).isEmpty());
        return RepeatStatus.FINISHED;
    }

    public void setSelectJobInstanceIdSql(String selectJobInstanceIdSql) {
        this.selectJobInstanceIdSql = selectJobInstanceIdSql;
    }

    public void setDeleteBatchJobExecutionContext(String deleteBatchJobExecutionContext) {
        this.deleteBatchJobExecutionContext = deleteBatchJobExecutionContext;
    }

    public void setDeleteBatchJobExecutionParam(String deleteBatchJobExecutionParam) {
        this.deleteBatchJobExecutionParam = deleteBatchJobExecutionParam;
    }

    public void setDeleteBatchJobExecution(String deleteBatchJobExecution) {
        this.deleteBatchJobExecution = deleteBatchJobExecution;
    }

    public void setDeleteBatchJobInstance(String deleteBatchJobInstance) {
        this.deleteBatchJobInstance = deleteBatchJobInstance;
    }

    public void setDeleteStepExecutionContext(String deleteStepExecutionContext) {
        this.deleteStepExecutionContext = deleteStepExecutionContext;
    }

    public void setDeleteStepExecution(String deleteStepExecution) {
        this.deleteStepExecution = deleteStepExecution;
    }

    public class BatchJobRowMapper
    implements RowMapper<BatchJobExeRow> {
        public BatchJobExeRow mapRow(ResultSet rs, int rownum) throws SQLException {
            BatchJobExeRow bean = new BatchJobExeRow();
            bean.setJobExecutionId(rs.getLong("JOB_EXECUTION_ID"));
            bean.setJobInstanceId(rs.getLong("JOB_INSTANCE_ID"));
            return bean;
        }
    }
}

