/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.job.tasklet;

import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

public class DailyBatchSummaryTasklet
implements Tasklet {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private String selectYesterdayNewSession;
    private String updateAppUserCount;
    Logger logger = LoggerFactory.getLogger(DailyBatchSummaryTasklet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepeatStatus execute(StepContribution stepContribution, ChunkContext chunkContext) throws Exception {
        List list = this.jdbcTemplate.queryForList(this.selectYesterdayNewSession, new Object[0]);
        int grpId = 0;
        int userCount = 0;
        long startTime = 0L;
        for (Map appInfo : list) {
            startTime = System.currentTimeMillis();
            if (appInfo.get("APP_GRP_ID") == null) continue;
            try {
                grpId = Integer.parseInt(appInfo.get("APP_GRP_ID").toString());
                userCount = Integer.parseInt(appInfo.get("NEW_SESS_CNT").toString());
                this.jdbcTemplate.update(this.updateAppUserCount, new Object[]{userCount, grpId});
            }
            catch (Exception e) {
                try {
                    this.logger.error("update user_count error", (Throwable)e);
                }
                catch (Throwable throwable) {
                    this.logger.info("[appGrpId:{}] update user_count += {} elapseTime:{}", new Object[]{grpId, userCount, System.currentTimeMillis() - startTime});
                    throw throwable;
                }
                this.logger.info("[appGrpId:{}] update user_count += {} elapseTime:{}", new Object[]{grpId, userCount, System.currentTimeMillis() - startTime});
                continue;
            }
            this.logger.info("[appGrpId:{}] update user_count += {} elapseTime:{}", new Object[]{grpId, userCount, System.currentTimeMillis() - startTime});
        }
        return RepeatStatus.FINISHED;
    }

    public void setSelectYesterdayNewSession(String selectYesterdayNewSession) {
        this.selectYesterdayNewSession = selectYesterdayNewSession;
    }

    public void setUpdateAppUserCount(String updateAppUserCount) {
        this.updateAppUserCount = updateAppUserCount;
    }
}

