/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.job.tasklet;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;

public class ClearDeleteDeviceListTasklet
implements Tasklet {
    private static final Logger log = LoggerFactory.getLogger(ClearDeleteDeviceListTasklet.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private String clearDeleteDeviceListSql;
    private String clearDeleteDeviceListUsingTruncateSql;
    @Value(value="#{config['delete.type.is.truncate']}")
    protected boolean isTruncate;

    public RepeatStatus execute(StepContribution stepContribution, ChunkContext chunkContext) throws Exception {
        log.info("delete.type.is.truncate : {}", (Object)this.isTruncate);
        try {
            if (this.isTruncate) {
                this.jdbcTemplate.execute(this.clearDeleteDeviceListUsingTruncateSql);
            } else {
                this.jdbcTemplate.execute(this.clearDeleteDeviceListSql);
            }
        }
        catch (Exception e) {
            log.error("clearDeleteDeviceListSql Fail : {}", (Throwable)e);
        }
        return RepeatStatus.FINISHED;
    }

    public void setClearDeleteDeviceListSql(String clearDeleteDeviceListSql) {
        this.clearDeleteDeviceListSql = clearDeleteDeviceListSql;
    }

    public void setClearDeleteDeviceListUsingTruncateSql(String clearDeleteDeviceListUsingTruncateSql) {
        this.clearDeleteDeviceListUsingTruncateSql = clearDeleteDeviceListUsingTruncateSql;
    }
}

