/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.job.partition;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.partition.support.Partitioner;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

public class MinMaxRangePartitioner
implements Partitioner {
    private static Logger logger = LoggerFactory.getLogger(MinMaxRangePartitioner.class);
    private static final int PARTITOINS_PER_NODE = 5;
    private static final int MIN_COUNT_PER_NODE = 100;
    private Long minId;
    private Long maxId;
    private Long scheduleId;
    private String sql;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public Map<String, ExecutionContext> partition(int gridSize) {
        long targetSize;
        long targetSizePerNode;
        if (this.maxId == null || this.minId == null) {
            logger.info("maxId:{}, minId:{}", (Object)this.maxId, (Object)this.minId);
            if (this.sql != null && this.scheduleId != null) {
                Map map = this.jdbcTemplate.queryForMap(this.sql, new Object[]{this.scheduleId});
                if (this.minId == null) {
                    this.minId = Long.parseLong(map.get("MIN_ID").toString());
                }
                if (this.maxId == null) {
                    this.maxId = Long.parseLong(map.get("MAX_ID").toString());
                }
                logger.info("jdbc select [maxId:{}, minId:{}]", (Object)this.maxId, (Object)this.minId);
            }
        }
        if ((targetSizePerNode = (targetSize = this.maxId - this.minId) / (long)(gridSize * 5) + 1L) <= 100L) {
            targetSizePerNode = 100L;
        }
        logger.info("gridSize :{}, targetSize:{}, targetSizePerNode:{}", new Object[]{gridSize, targetSize, targetSizePerNode});
        HashMap<String, ExecutionContext> result = new HashMap<String, ExecutionContext>();
        int number = 0;
        long start = this.minId;
        long end = start + targetSizePerNode - 1L;
        while (start <= this.maxId) {
            ExecutionContext value = new ExecutionContext();
            result.put("partition" + number, value);
            if (end >= this.maxId) {
                end = this.maxId;
            }
            value.putLong("partition.min.value", start);
            value.putLong("partition.max.value", end);
            start += targetSizePerNode;
            end += targetSizePerNode;
            ++number;
        }
        logger.info("execution partition:{}", (Object)((Object)result).toString());
        return result;
    }

    public void setMaxId(Long maxId) {
        this.maxId = maxId;
    }

    public void setMinId(Long minId) {
        this.minId = minId;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setScheduleId(Long scheduleId) {
        this.scheduleId = scheduleId;
    }

    public static void main(String[] args) {
        MinMaxRangePartitioner partitioner = new MinMaxRangePartitioner();
        partitioner.setMinId(1L);
        partitioner.setMaxId(500L);
        partitioner.partition(5);
    }
}

