/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.job.partition;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyDivider {
    private static final Logger log = LoggerFactory.getLogger(KeyDivider.class);
    private int[] divisionCount;
    private String[] ids;
    private int position = 0;
    private int cumulativeCount = 0;
    private String keyName;
    private String valueName;

    public KeyDivider(String keyName, String valueName) {
        this.keyName = keyName;
        this.valueName = valueName;
    }

    public double getPercent(Properties server) {
        return Double.parseDouble(server.getProperty(this.valueName, "50"));
    }

    public boolean isServerListZero(int totalCount, List<Properties> idList) {
        if (idList == null || idList.isEmpty()) {
            this.defaultInit();
            return true;
        }
        return false;
    }

    public void defaultInit() {
        this.divisionCount = new int[this.position + 1];
        this.divisionCount[this.position] = 1000000000;
        this.ids = new String[this.position + 1];
        this.ids[this.position] = "01";
    }

    public void defaultInit(int totalCount) {
        if (totalCount <= 0) {
            this.defaultInit();
        }
        this.divisionCount = new int[this.position + 2];
        this.ids = new String[this.position + 2];
        this.divisionCount[0] = totalCount / 2;
        this.ids[0] = "01";
        this.divisionCount[1] = totalCount + 1;
        this.ids[1] = "02";
    }

    public void setPosition(int count) {
        for (int i = 0; i < this.divisionCount.length; ++i) {
            if (this.divisionCount[i] <= count) continue;
            this.position = i;
            return;
        }
    }

    public void divisionId(int totalCount, List<Properties> serverList) throws Exception {
        if (this.isServerListZero(totalCount, serverList)) {
            return;
        }
        try {
            this.divisionCount = new int[serverList.size()];
            this.ids = new String[serverList.size()];
            for (int i = 0; i < this.divisionCount.length; ++i) {
                this.divisionCount[i] = (int)((double)totalCount * this.getPercent(serverList.get(i)) / 100.0) + this.cumulativeCount;
                if (this.divisionCount[i] == 0) {
                    this.divisionCount[i] = 1;
                }
                this.cumulative(this.divisionCount[i]);
                this.ids[i] = serverList.get(i).getProperty(this.keyName);
            }
            this.divisionCount[this.divisionCount.length - 1] = this.divisionCount[this.divisionCount.length - 1] + serverList.size() + 1;
        }
        catch (Exception e) {
            log.error("divisionServer error", (Throwable)e);
            this.isServerListZero(totalCount, serverList);
        }
    }

    private void cumulative(int count) {
        this.cumulativeCount = count;
    }

    public String getId(long count) {
        try {
            return (long)this.divisionCount[this.position] > count ? this.ids[this.position] : this.ids[++this.position];
        }
        catch (Exception e) {
            log.error("count :{}, divisionCount:{}, position:{}", new Object[]{count, this.divisionCount.length, this.position});
            e.printStackTrace();
            return this.ids[this.position];
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.divisionCount.length; ++i) {
            try {
                if (i > 0) {
                    sb.append(" , ");
                }
                sb.append("{id[").append(i).append("]=").append(this.ids[i]).append(",");
                sb.append("divisionCount[").append(i).append("]=").append(this.divisionCount[i]).append("}");
                continue;
            }
            catch (Exception e) {
                log.error("toString error [toString:{}]", (Object)sb.toString(), (Object)e);
            }
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        KeyDivider s = new KeyDivider("SERVER_ID", "PARTICIPATION_RATE");
        ArrayList<Properties> list = new ArrayList<Properties>();
        Properties prop = new Properties();
        prop.setProperty("SERVER_ID", "01");
        prop.setProperty("PARTICIPATION_RATE", "10.0");
        list.add(prop);
        Properties prop1 = new Properties();
        prop1.setProperty("SERVER_ID", "02");
        prop1.setProperty("PARTICIPATION_RATE", "10.0");
        list.add(prop1);
        Properties prop2 = new Properties();
        prop2.setProperty("SERVER_ID", "03");
        prop2.setProperty("PARTICIPATION_RATE", "80.0");
        list.add(prop2);
        try {
            int targetCnt = 10;
            s.divisionId(targetCnt, list);
            for (int i = 0; i < targetCnt; ++i) {
                System.out.println(i + " " + s.getId(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(s.toString());
    }
}

