/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.job.partition;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.partition.support.Partitioner;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;

public class JdbcColumnRangePartitioner
implements Partitioner {
    private static final Logger log = LoggerFactory.getLogger(JdbcColumnRangePartitioner.class);
    private static final int PARTITOINS_PER_NODE = 5;
    private static final int MIN_COUNT_PER_NODE = 1000;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private String fromClause;
    private String column;
    private String whereClause;

    public Map<String, ExecutionContext> partition(int gridSize) {
        int partitionCount = gridSize * 5;
        String minQuery = "SELECT MIN(" + this.column + ") from " + this.fromClause;
        String maxQuery = "SELECT MAX(" + this.column + ") from " + this.fromClause;
        if (StringUtils.hasLength((String)this.whereClause)) {
            minQuery = minQuery + " WHERE " + this.whereClause;
            maxQuery = maxQuery + " WHERE " + this.whereClause;
        }
        log.info("minQuery : {}", (Object)minQuery);
        log.info("maxQuery : {}", (Object)maxQuery);
        int min = (Integer)this.jdbcTemplate.queryForObject(minQuery, Integer.class);
        int max = (Integer)this.jdbcTemplate.queryForObject(maxQuery, Integer.class);
        int targetSize = (max - min) / partitionCount * 1000 + 1;
        HashMap<String, ExecutionContext> result = new HashMap<String, ExecutionContext>();
        int number = 0;
        int start = min;
        int end = start + targetSize - 1;
        log.info("TB_SEND_RAW [min:{}, max:{}]", (Object)min, (Object)max);
        while (start <= max) {
            ExecutionContext value = new ExecutionContext();
            result.put("partition" + number, value);
            if (end >= max) {
                end = max;
            }
            value.putLong("minValue", (long)start);
            value.putLong("maxValue", (long)end);
            start += targetSize;
            end += targetSize;
            ++number;
        }
        return result;
    }

    public void setFromClause(String fromClause) {
        this.fromClause = fromClause;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public void setWhereClause(String whereClause) {
        this.whereClause = whereClause;
    }
}

