/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.job.listener;

import com.humuson.tms.batch.domain.TargetSchedule;
import com.humuson.tms.batch.service.ScheduleService;
import com.humuson.tms.constrants.TargetStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.beans.factory.annotation.Autowired;

public class TargetingJobListener
implements JobExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(TargetingJobListener.class);
    @Autowired
    private ScheduleService<TargetSchedule> targetingScheduleService;

    public void beforeJob(JobExecution jobExecution) {
        log.info("Start jobName: {} ,param:[{}]", (Object)jobExecution.getJobConfigurationName(), (Object)jobExecution.getJobParameters().toProperties());
    }

    public void afterJob(JobExecution jobExecution) {
        String msgId = jobExecution.getJobParameters().getString("msg.id");
        log.info("End jobName: {} ,param:[{}]", (Object)jobExecution.getJobConfigurationName(), (Object)jobExecution.getJobParameters().toProperties());
        this.targetingScheduleService.setRunning(msgId, false);
        if (jobExecution.getStatus() == BatchStatus.COMPLETED) {
            this.targetingScheduleService.updateScheduleStatus(msgId, TargetStatus.COMPLETE.getCode());
        } else if (jobExecution.getStatus() == BatchStatus.STOPPED || jobExecution.getStatus() == BatchStatus.STOPPING) {
            this.targetingScheduleService.updateScheduleStatus(msgId, TargetStatus.CANCEL_COMPLETE.getCode());
        } else {
            this.targetingScheduleService.updateScheduleStatus(msgId, TargetStatus.ERROR.getCode());
        }
    }
}

