/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.job.listener;

import com.humuson.tms.batch.domain.PushMqReSendSchedule;
import com.humuson.tms.batch.service.ScheduleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.beans.factory.annotation.Autowired;

public class PushMqReSendJobListener
implements JobExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(PushMqReSendJobListener.class);
    @Autowired
    private ScheduleService<PushMqReSendSchedule> pushMqReSendScheduleService;

    public void beforeJob(JobExecution jobExecution) {
        log.info("Start jobName: {} ,param:[{}]", (Object)jobExecution.getJobConfigurationName(), (Object)jobExecution.getJobParameters().toProperties());
    }

    public void afterJob(JobExecution jobExecution) {
        log.info("End jobName: {} ,param:[{}]", (Object)jobExecution.getJobConfigurationName(), (Object)jobExecution.getJobParameters().toProperties());
        String appGrpKey = jobExecution.getJobParameters().getString("app.grp.key", "");
        String serverId = jobExecution.getJobParameters().getString("server.id", "");
        String sendType = jobExecution.getJobParameters().getString("send.type", "");
        this.pushMqReSendScheduleService.setRunning(appGrpKey + "-" + sendType + "-" + serverId, false);
    }
}

