/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.job.listener;

import com.humuson.tms.batch.domain.OptmzSchedule;
import com.humuson.tms.batch.service.OptmzChannelService;
import com.humuson.tms.batch.service.ScheduleService;
import com.humuson.tms.constrants.StatusType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.beans.factory.annotation.Autowired;

public class OptmzManualChannelJobListener
implements JobExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(OptmzManualChannelJobListener.class);
    @Autowired
    private OptmzChannelService optmzManualChannelService;
    @Autowired
    private ScheduleService<OptmzSchedule> optmzManualChnTargetScheduleService;

    public void beforeJob(JobExecution jobExecution) {
        log.info("Start jobName: {} ,param:[{}]", (Object)jobExecution.getJobConfigurationName(), (Object)jobExecution.getJobParameters().toProperties());
        String postId = jobExecution.getJobParameters().getString("post.id");
        String msgId = jobExecution.getJobParameters().getString("msg.id");
        String channelType = jobExecution.getJobParameters().getString("chn.type");
        this.optmzManualChannelService.insertTargetServer(postId, msgId, channelType);
    }

    public void afterJob(JobExecution jobExecution) {
        log.info("End jobName:{}, status:{}, param:[{}]", new Object[]{jobExecution.getJobConfigurationName(), jobExecution.getStatus(), jobExecution.getJobParameters().toProperties()});
        String postId = jobExecution.getJobParameters().getString("post.id");
        String msgId = jobExecution.getJobParameters().getString("msg.id");
        String channelType = jobExecution.getJobParameters().getString("chn.type");
        if (jobExecution.getStatus() == BatchStatus.COMPLETED) {
            String stepApprovalUseYn = jobExecution.getJobParameters().getString("step.approval.use.yn");
            log.info("optmz schedule regist STEP_APPROVAL_USE_YN : {}", (Object)stepApprovalUseYn);
            this.optmzManualChannelService.registScheduleInfo(postId, msgId, channelType, stepApprovalUseYn);
            log.info("optmz schedule regist");
            this.optmzManualChnTargetScheduleService.updateScheduleStatus(postId, StatusType.COMPLETE.getCode());
        } else {
            log.error("optmz schedule error");
            this.optmzManualChnTargetScheduleService.updateScheduleStatus(postId, StatusType.ERROR.getCode());
        }
    }
}

