/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.job.launcher;

import java.util.Date;
import java.util.Map;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.configuration.JobLocator;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class JobLauncherQuartzBean
extends QuartzJobBean {
    private static final Logger log = LoggerFactory.getLogger(JobLauncherQuartzBean.class);
    public static final String KEY_JOB_PARAM_DATE = "quartz_job_date";
    public static final String JOB_LOCATOR_CONTEXT_KEY = "jobLocator";
    public static final String JOB_LAUNCHER_CONTEXT_KEY = "jobLauncher";
    public static final String JOB_NAME = "jobName";
    JobLocator jobLocator;
    JobLauncher jobLauncher;

    private void init(JobExecutionContext context) {
        try {
            this.jobLocator = (JobLocator)context.getScheduler().getContext().get((Object)JOB_LOCATOR_CONTEXT_KEY);
            this.jobLauncher = (JobLauncher)context.getScheduler().getContext().get((Object)JOB_LAUNCHER_CONTEXT_KEY);
        }
        catch (SchedulerException e) {
            log.error("JobLauncherQuartzBean init error", (Throwable)e);
        }
    }

    protected JobParameters getJobParametersFromJobMap(Map<String, Object> jobDataMap) {
        JobParametersBuilder builder = new JobParametersBuilder();
        for (Map.Entry<String, Object> entry : jobDataMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String && !key.equals(JOB_NAME)) {
                builder.addString(key, (String)value);
                continue;
            }
            if (value instanceof Float || value instanceof Double) {
                builder.addDouble(key, Double.valueOf(((Number)value).doubleValue()));
                continue;
            }
            if (value instanceof Integer || value instanceof Long) {
                builder.addLong(key, Long.valueOf(((Number)value).longValue()));
                continue;
            }
            if (value instanceof Date) {
                builder.addDate(key, (Date)value);
                continue;
            }
            log.debug("JobDataMap contains values which are not job parameters (ignoring). [key:{}, value:{}]", (Object)key, value);
        }
        return builder.toJobParameters();
    }

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        this.init(context);
        JobDataMap jobDataMap = context.getMergedJobDataMap();
        jobDataMap.put(KEY_JOB_PARAM_DATE, System.currentTimeMillis());
        String jobName = jobDataMap.get(JOB_NAME).toString();
        JobParameters jobParameters = this.getJobParametersFromJobMap((Map<String, Object>)jobDataMap);
        try {
            this.jobLauncher.run(this.jobLocator.getJob(jobName), jobParameters);
        }
        catch (Exception e) {
            log.error("job execute error jobName : {}, jobParameters : [{}]", (Object)jobName, (Object)jobParameters);
        }
    }
}

