/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.job.decision;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.JobExecutionDecider;

public class ThreadTypeDecider
implements JobExecutionDecider {
    private static final Logger log = LoggerFactory.getLogger(ThreadTypeDecider.class);
    private int singleThreadMaxTargetCount = 1000;

    public FlowExecutionStatus decide(JobExecution jobExecution, StepExecution stepExecution) {
        if (ExitStatus.COMPLETED.getExitCode().equals(stepExecution.getExitStatus().getExitCode())) {
            int totalTargetCnt = stepExecution.getJobExecution().getExecutionContext().getInt("tot.cnt");
            if (totalTargetCnt > this.singleThreadMaxTargetCount) {
                return new FlowExecutionStatus("MULTI");
            }
            return new FlowExecutionStatus("SINGLE");
        }
        log.error("Step ExistCode:{}, param[{}]", (Object)stepExecution.getExitStatus().getExitCode(), (Object)stepExecution.toString());
        return new FlowExecutionStatus(ExitStatus.STOPPED.getExitCode());
    }
}

