/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.job.decision;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.JobExecutionDecider;

public class TargetTypeDecider
implements JobExecutionDecider {
    private static final Logger log = LoggerFactory.getLogger(TargetTypeDecider.class);

    public FlowExecutionStatus decide(JobExecution jobExecution, StepExecution stepExecution) {
        if (ExitStatus.COMPLETED.getExitCode().equals(stepExecution.getExitStatus().getExitCode())) {
            String targetType = stepExecution.getJobExecution().getExecutionContext().get("target.type").toString();
            log.info("targetType : {}", (Object)targetType);
            return new FlowExecutionStatus(targetType);
        }
        log.error("Step ExistCode:{}, param[{}]", (Object)stepExecution.getExitStatus().getExitCode(), (Object)stepExecution.toString());
        return new FlowExecutionStatus(ExitStatus.STOPPED.getExitCode());
    }
}

