/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.item.redis;

import com.humuson.tms.batch.domain.PushResult;
import com.humuson.tms.common.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.NonTransientResourceException;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.StringRedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;

public class PrivateFeedbackRedisItemReader
implements ItemReader<PushResult>,
StepExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(PrivateFeedbackRedisItemReader.class);
    private List<PushResult> results;
    private int currentReadCount = 0;
    private int currentItemCount = 0;
    private int maxItemCount = Integer.MAX_VALUE;
    @Value(value="#{dbConfig['commit.interval']}")
    private int feedbackCount;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    private String appKey;
    private long appGrpId;

    public void beforeStep(StepExecution stepExecution) {
        this.appKey = stepExecution.getJobParameters().getString("app.key");
        this.appGrpId = stepExecution.getJobParameters().getLong("app.grp.id");
    }

    public PushResult read() throws Exception, UnexpectedInputException, ParseException, NonTransientResourceException {
        if (this.currentItemCount >= this.maxItemCount) {
            return null;
        }
        return this.doRead();
    }

    private synchronized PushResult doRead() throws Exception {
        if (this.results == null || this.currentReadCount >= this.currentItemCount) {
            this.doMoreFeedbackList();
            if (this.results != null && log.isDebugEnabled()) {
                log.debug("reader size : {}", (Object)this.currentItemCount);
            }
        }
        int next = this.currentReadCount++;
        if (this.results != null && next < this.results.size()) {
            return this.results.get(next);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getFeedbackList(final int limitCount) {
        ArrayList<String> returnList = new ArrayList<String>();
        long startTime = System.currentTimeMillis();
        try {
            StringBuilder sb = new StringBuilder();
            final String key = sb.append("feedbacks").append(":").append(this.appKey).toString();
            final long feedbackSize = this.redisTemplate.opsForList().size((Object)key);
            if (feedbackSize > 0L) {
                List results = this.redisTemplate.executePipelined((RedisCallback)new RedisCallback<Object>(){

                    public Object doInRedis(RedisConnection connection) throws DataAccessException {
                        StringRedisConnection stringRedisConnection = (StringRedisConnection)connection;
                        long batchSize = limitCount;
                        if (feedbackSize < (long)limitCount) {
                            batchSize = feedbackSize;
                        }
                        int i = 0;
                        while ((long)i < batchSize) {
                            stringRedisConnection.lPop(key);
                            ++i;
                        }
                        return null;
                    }
                });
                for (Object obj : results) {
                    returnList.add(obj.toString());
                }
            }
        }
        catch (Exception e) {
            log.error("error : {}", (Throwable)e);
        }
        finally {
            log.debug("REDIS --> popFeedbackList elapsed time : {}", (Object)(System.currentTimeMillis() - startTime));
        }
        return returnList;
    }

    private void doMoreFeedbackList() {
        if (this.results == null) {
            this.results = new CopyOnWriteArrayList<PushResult>();
            this.currentItemCount = 0;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        List<String> feedbackList = this.getFeedbackList(this.feedbackCount);
        if (feedbackList != null && !feedbackList.isEmpty()) {
            log.info("appKey : {}, res size : {}", (Object)this.appKey, (Object)feedbackList.size());
            String reqeustId = null;
            for (String jsonStr : feedbackList) {
                try {
                    JSONObject json = (JSONObject)JSONValue.parse((String)jsonStr);
                    int status = 3105;
                    try {
                        status = Integer.parseInt((String)json.get((Object)"status"));
                    }
                    catch (Exception e) {
                        log.error("Integer.parseInt error : [jsonStr:{}]", (Object)json.toString());
                    }
                    String recvTime = (String)json.get((Object)"recv_time");
                    String sendTime = (String)json.get((Object)"send_time");
                    if (!StringUtils.isNull((String)recvTime)) {
                        try {
                            recvTime = sdf.format(new Date(Long.parseLong(recvTime)));
                        }
                        catch (Exception e) {
                            log.error("recvTime parse error [recvTime:{}]", (Object)recvTime);
                            recvTime = null;
                        }
                    }
                    if (!StringUtils.isNull((String)sendTime)) {
                        try {
                            sendTime = sdf.format(new Date(Long.parseLong(sendTime)));
                        }
                        catch (Exception e) {
                            log.error("sendTime error [recvTime:{}]", (Object)recvTime);
                            sendTime = null;
                        }
                    }
                    if ((reqeustId = (String)json.get((Object)"request_id")) != null) {
                        this.results.add(new PushResult((int)this.appGrpId, String.valueOf(status), reqeustId, "A", null).setRecvTime(recvTime).setSendTime(sendTime));
                        ++this.currentItemCount;
                        continue;
                    }
                    log.error("requestId is null [{}]", (Object)json.toString());
                }
                catch (Exception e) {
                    log.error("FEEDBACK parse error skip feedback info : {}", (Object)jsonStr);
                }
            }
        }
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        log.info("step read count : {}, currentReadCount : {}, currentItemCount : {} result size : {}", new Object[]{stepExecution.getReadCount(), this.currentReadCount, this.currentItemCount, this.results == null ? 0 : this.results.size()});
        return stepExecution.getExitStatus();
    }
}

