/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.item.database;

import com.humuson.tms.batch.service.SystemCodeService;
import com.humuson.tms.common.model.target.TargetData;
import com.humuson.tms.common.security.HumusonDecryptor;
import com.humuson.tms.common.security.HumusonEncryptor;
import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.constrants.ChannelType;
import com.humuson.tms.service.MemberFieldSecurityService;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;

public class TargetProcessor
implements ItemProcessor<TargetData, TargetData>,
StepExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(TargetProcessor.class);
    protected String firstChnType;
    protected String chnType;
    protected String msgId;
    protected String postId;
    protected String targetType;
    protected String idTargetYn;
    protected String abTestYn;
    protected Long targetCount;
    protected int abTestCount;
    protected String abTestRate;
    protected String sourceTargetEncryptYn;
    protected String dbEncryptFlag;
    protected List<String> channelList;
    protected String mktYn;
    private String addSiteUserYn;
    protected String deduplicationYn;
    protected String seqNo;
    private String updateFilterCount;
    private String selectAbTestInfo;
    private String selectChnList;
    private String selectAppDevice;
    private String selectUnLoginAppDevice;
    private String selectSiteUser;
    private String insertTargetErrorList;
    @Autowired
    protected SystemCodeService systemCodeServiceImpl;
    @Autowired
    protected MemberFieldSecurityService memberFieldSecurityServiceImpl;
    @Autowired
    protected JdbcTemplate jdbcTemplate;
    @Value(value="#{config['tms.db.enc.key']}")
    protected String encKey;
    protected Map<String, Integer> filterMap;
    protected Map<String, Integer> readerMap;
    protected Map<String, Integer> writerMap;
    protected AtomicInteger readerCount = new AtomicInteger();
    protected AtomicInteger errorCount = new AtomicInteger();
    protected int maxChunkSize = 10;
    protected int siteId = -1;
    protected int appGrpId = -1;
    private Random rnd = new Random();

    /*
     * Unable to fully structure code
     */
    protected boolean checkValidation(TargetData item) throws Exception {
        block25: {
            isValidation = true;
            if (StringUtils.isNull((String)item.getMemberId())) {
                this.errorCount.incrementAndGet();
                TargetProcessor.log.info("TMS_M_ID is null [{}]", (Object)item.toString());
                return false;
            }
            if (ChannelType.PUSH.getCode().equals(this.firstChnType)) {
                if ("Y".equals(this.mktYn) && StringUtils.isNull((String)item.getMktYn()) || StringUtils.isNull((String)item.getMemberToken()) || StringUtils.isNull((String)item.getDeviceId())) {
                    try {
                        map = item.getMemberId().startsWith("TMS-") != false ? this.jdbcTemplate.queryForMap(this.selectUnLoginAppDevice, new Object[]{this.siteId, item.getMemberId(), this.appGrpId}) : this.jdbcTemplate.queryForMap(this.selectAppDevice, new Object[]{this.siteId, item.getMemberId(), this.appGrpId});
                        if (StringUtils.isNull((String)item.getMemberToken())) {
                            item.setMemberToken(map.get("TMS_M_TOKEN").toString());
                        }
                        if (StringUtils.isNull((String)item.getDeviceId())) {
                            item.setDeviceId(map.get("DEVICE_ID").toString());
                        }
                        if (!StringUtils.isNull((String)item.getMktYn())) ** GOTO lbl61
                        item.setMktYn(map.get("MKT_YN").toString());
                    }
                    catch (Exception e) {
                        TargetProcessor.log.error("no exists appDevice [memberId:{}], error:{}", (Object)item.getMemberId(), (Object)e.getMessage());
                        return false;
                    }
                }
            } else if (ChannelType.EMAIL.getCode().equals(this.firstChnType)) {
                if ("Y".equals(this.mktYn) || StringUtils.isNull((String)item.getMemberEmail())) {
                    try {
                        map = this.jdbcTemplate.queryForMap(this.selectSiteUser, new Object[]{this.siteId, item.getMemberId()});
                        if (StringUtils.isNull((String)item.getMktYn())) {
                            item.setMktYn(map.get("MKT_YN").toString());
                        }
                        if (StringUtils.isNull((String)item.getMemberName())) {
                            item.setMemberName(map.get("TMS_M_NAME").toString());
                        }
                        if (!StringUtils.isNull((String)item.getMemberEmail())) ** GOTO lbl61
                        item.setMemberEmail(map.get("TMS_M_EMAIL").toString());
                    }
                    catch (Exception e) {
                        if ("Y".equals(this.addSiteUserYn)) ** GOTO lbl61
                        TargetProcessor.log.error("no exists siteUser [siteId:{}, memberId:{}], error:{}]", new Object[]{this.siteId, item.getMemberId(), e.getMessage()});
                        return false;
                    }
                }
            } else if (ChannelType.SMS.getCode().equals(this.firstChnType) && ("Y".equals(this.mktYn) || StringUtils.isNull((String)item.getMemberPhone()))) {
                try {
                    map = this.jdbcTemplate.queryForMap(this.selectSiteUser, new Object[]{this.siteId, item.getMemberId()});
                    if (StringUtils.isNull((String)item.getMktYn())) {
                        item.setMktYn(map.get("MKT_YN").toString());
                    }
                    if (StringUtils.isNull((String)item.getMemberName())) {
                        item.setMemberName(map.get("TMS_M_NAME").toString());
                    }
                    if (StringUtils.isNull((String)item.getMemberPhone())) {
                        item.setMemberPhone(map.get("TMS_M_PHONE").toString());
                    }
                }
                catch (Exception e) {
                    if ("Y".equals(this.addSiteUserYn)) break block25;
                    TargetProcessor.log.error("no exists siteUser [siteId:{}, memberId:{}], error:{}]", new Object[]{this.siteId, item.getMemberId(), e.getMessage()});
                    return false;
                }
            }
        }
        if ("Y".equals(this.mktYn) && "N".equals(item.getMktYn())) {
            TargetProcessor.log.error("mkt flag 'N' [tms_m_id:{}, tms_m_name:{}]", (Object)item.getMemberId(), (Object)item.getMemberName());
            return false;
        }
        if (this.channelList.contains(ChannelType.EMAIL.getCode())) {
            isValidation = this.checkValidationEmailChannel(item);
        }
        if (this.channelList.contains(ChannelType.SMS.getCode())) {
            isValidation = this.checkValidationSmsChannel(item);
        }
        if (this.channelList.contains(ChannelType.PUSH.getCode())) {
            isValidation = this.checkValidationPushChannel(item);
        }
        return isValidation;
    }

    private boolean checkValidationSmsChannel(TargetData item) {
        String phone = item.getMemberPhone();
        if (phone == null) {
            return false;
        }
        if ("Y".equals(this.sourceTargetEncryptYn)) {
            try {
                phone = HumusonDecryptor.decrypt((String)item.getMemberPhone(), (String)this.encKey, (boolean)false);
            }
            catch (Exception e) {
                log.error("sms decrypt error [{}] msg:{}", (Object)phone, (Object)e.getMessage());
            }
        }
        phone = phone.replaceAll("-", "");
        if (ChannelType.SMS.getCode().equals(this.firstChnType) && StringUtils.isSmsError((String)phone)) {
            return false;
        }
        item.setTelCode(StringUtils.getTeleCom((String)phone));
        if ("Y".equals(this.dbEncryptFlag)) {
            item.setMemberPhone(HumusonEncryptor.encrypt((String)phone, (String)this.encKey, (boolean)false));
        } else {
            item.setMemberPhone(phone);
        }
        return true;
    }

    private boolean checkValidationPushChannel(TargetData item) {
        if (ChannelType.PUSH.getCode().equals(this.firstChnType) && (StringUtils.isNull((String)item.getDeviceId()) || StringUtils.isNull((String)item.getMemberToken()))) {
            try {
                Map map = this.jdbcTemplate.queryForMap(this.selectAppDevice, new Object[]{this.siteId, item.getMemberId(), this.appGrpId});
                if (StringUtils.isNull((String)item.getMemberToken())) {
                    item.setMemberToken(map.get("TMS_M_TOKEN").toString());
                }
                if (StringUtils.isNull((String)item.getDeviceId())) {
                    item.setDeviceId(map.get("DEVICE_ID").toString());
                }
                if (StringUtils.isNull((String)item.getMktYn())) {
                    item.setMktYn(map.get("MKT_YN").toString());
                }
            }
            catch (Exception e) {
                log.error("no exists appDevice [memberId:{}], error:{}", (Object)item.getMemberId(), (Object)e.getMessage());
                return false;
            }
        }
        return true;
    }

    private boolean checkValidationEmailChannel(TargetData item) {
        String email = item.getMemberEmail();
        if ("Y".equals(this.sourceTargetEncryptYn) || email.indexOf(64) < 0) {
            try {
                email = HumusonDecryptor.decrypt((String)item.getMemberEmail(), (String)this.encKey, (boolean)false);
            }
            catch (Exception e) {
                log.error("email decrypt error [{}] msg:{}", (Object)email, (Object)e.getMessage());
            }
        }
        if (ChannelType.EMAIL.getCode().equals(this.firstChnType) && StringUtils.isEmailError((String)email)) {
            return false;
        }
        item.setDomain(StringUtils.getDomain((String)email));
        if ("Y".equals(this.dbEncryptFlag)) {
            item.setMemberEmail(HumusonEncryptor.encrypt((String)email, (String)this.encKey, (boolean)false));
        } else {
            item.setMemberEmail(email);
        }
        return true;
    }

    public TargetData process(TargetData item) throws Exception {
        try {
            if (!this.checkValidation(item)) {
                this.jdbcTemplate.update(this.insertTargetErrorList, new Object[]{this.firstChnType, this.msgId, this.seqNo, item.getMemberId(), this.firstChnType.equals("EM") ? item.getMemberEmail() : (this.firstChnType.equals("SM") ? item.getMemberPhone() : item.getDeviceId()), "IE"});
                this.increamentFilterCnt();
                return null;
            }
        }
        catch (Exception e) {
            log.error("CheckValidation error [item:{}], msg:{}", (Object)item.toString(), (Object)e.getMessage());
            return null;
        }
        this.readerCount.incrementAndGet();
        item.setChannelType(this.firstChnType);
        item.setSiteId(this.siteId);
        item.setChunkId(String.valueOf(this.rnd.nextInt(this.maxChunkSize)));
        item.setMsgId(this.msgId);
        item.setSeqNo(this.seqNo);
        if ("Y".equals(this.deduplicationYn)) {
            if (ChannelType.EMAIL.getCode().equals(this.firstChnType)) {
                item.setDuplicateKey(item.getMemberEmail());
            } else if (ChannelType.SMS.getCode().equals(this.firstChnType)) {
                item.setDuplicateKey(item.getMemberPhone());
            } else if (ChannelType.PUSH.getCode().equals(this.firstChnType)) {
                item.setDuplicateKey(item.getDeviceId());
            }
        }
        return item;
    }

    protected synchronized void increamentFilterCnt() {
        Integer filterCnt = this.filterMap.get(this.chnType);
        if (filterCnt == null) {
            filterCnt = 0;
        }
        filterCnt = filterCnt + 1;
        this.filterMap.put(this.chnType, filterCnt);
    }

    public void beforeStep(StepExecution stepExecution) {
        this.filterMap = new ConcurrentHashMap<String, Integer>();
        this.readerMap = new ConcurrentHashMap<String, Integer>();
        this.writerMap = new ConcurrentHashMap<String, Integer>();
        this.chnType = stepExecution.getJobParameters().getString("chn.type");
        this.msgId = stepExecution.getJobParameters().getString("msg.id");
        this.postId = stepExecution.getJobParameters().getString("post.id");
        this.targetType = stepExecution.getJobParameters().getString("target.type");
        this.idTargetYn = stepExecution.getJobExecution().getExecutionContext().getString("id.target.yn", "N");
        this.sourceTargetEncryptYn = stepExecution.getJobExecution().getExecutionContext().getString("encrypt.yn", "N");
        this.siteId = stepExecution.getJobExecution().getExecutionContext().getInt("site.id", 0);
        this.firstChnType = stepExecution.getJobExecution().getExecutionContext().getString("1st.chn.type");
        this.mktYn = stepExecution.getJobExecution().getExecutionContext().getString("mkt.yn", "N");
        this.dbEncryptFlag = this.systemCodeServiceImpl.getDbEncryptYn();
        this.addSiteUserYn = stepExecution.getJobExecution().getExecutionContext().getString("add.site.user.yn", "N");
        this.deduplicationYn = stepExecution.getJobParameters().getString("deduplication.yn");
        this.seqNo = stepExecution.getJobExecution().getExecutionContext().getString("seq.no");
        this.channelList = this.jdbcTemplate.queryForList(this.selectChnList, new Object[]{this.msgId}, String.class);
        this.appGrpId = stepExecution.getJobExecution().getExecutionContext().getInt("app.grp.id");
        log.info("siteId :{}, msgId:{} targetType:{}, idTargetYn:{}, dbEncryptFlag:{}, sourceEncryptYn:{}, deduplicationYn:{}, appGrpId:{}", new Object[]{this.siteId, this.msgId, this.targetType, this.idTargetYn, this.dbEncryptFlag, this.sourceTargetEncryptYn, this.deduplicationYn, this.appGrpId});
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        if (log.isDebugEnabled()) {
            log.debug("target filter [{}]", (Object)this.filterMap.toString());
        }
        Set<String> channelCodeSet = this.filterMap.keySet();
        for (String channelCode : channelCodeSet) {
            log.info("update FilterCount [channelCode:{}, msgId:{}, postId:{}, filterCnt:{}]", new Object[]{channelCode, this.msgId, this.postId, this.filterMap.get(channelCode)});
            this.jdbcTemplate.update(this.updateFilterCount, new Object[]{this.filterMap.get(channelCode), 0, 0, this.msgId});
        }
        return stepExecution.getExitStatus();
    }

    public void setUpdateFilterCount(String updateFilterCount) {
        this.updateFilterCount = updateFilterCount;
    }

    public void setSelectAbTestInfo(String selectAbTestInfo) {
        this.selectAbTestInfo = selectAbTestInfo;
    }

    public void setSelectChnList(String selectChnList) {
        this.selectChnList = selectChnList;
    }

    public void setSelectAppDevice(String selectAppDevice) {
        this.selectAppDevice = selectAppDevice;
    }

    public void setSelectUnLoginAppDevice(String selectUnLoginAppDevice) {
        this.selectUnLoginAppDevice = selectUnLoginAppDevice;
    }

    public void setSelectSiteUser(String selectSiteUser) {
        this.selectSiteUser = selectSiteUser;
    }

    public void setInsertTargetErrorList(String insertTargetErrorList) {
        this.insertTargetErrorList = insertTargetErrorList;
    }
}

