/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.item.database;

import com.humuson.tms.batch.domain.ChannelSendType;
import com.humuson.tms.batch.domain.PushResultLog;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ItemProcessor;

public class SmsLogProcessor
implements ItemProcessor<PushResultLog, PushResultLog>,
StepExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(SmsLogProcessor.class);
    AtomicInteger errorCount = new AtomicInteger();

    public PushResultLog process(PushResultLog item) throws Exception {
        int pos;
        String postId = item.getPostId();
        if (item.getChannelSendType().equals((Object)ChannelSendType.AUTO) && (pos = postId.lastIndexOf(95)) > -1) {
            item.setWorkday(postId.substring(0, pos));
            item.setSeqNo(postId.substring(pos + 1));
        }
        return item;
    }

    public void beforeStep(StepExecution stepExecution) {
        log.debug("SmsLogProcessor beforeStep");
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        log.info("push que log error count : {}", (Object)this.errorCount.get());
        return stepExecution.getExitStatus();
    }
}

