/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.item.database;

import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.domain.PushQueue;
import com.humuson.tms.batch.service.PushInfoService;
import com.humuson.tms.batch.service.PushResultService;
import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.constrants.StatusType;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;

public class PushSendProcessor
implements ItemProcessor<PushQueue, PushQueue>,
StepExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(PushSendProcessor.class);
    static final String HEAD = "<head>";
    static final String MAPPING_MSG_ID_KEYWORD = "[$]\\{MSG_ID\\}";
    static final String MAPPING_TYPE_KEYWORD = "[$]\\{TYPE\\}";
    @Autowired
    protected JdbcTemplate jdbcTemplate;
    @Autowired
    protected PushResultService pushResultService;
    @Autowired
    protected PushInfoService<App, PushMessage> pushInfoService;
    @Value(value="#{config['rich.content.charset.header']}")
    protected String charsetHeader;
    @Value(value="#{config['rich.content.msg.id.header']}")
    protected String msgIdHeader;
    @Value(value="#{config['rich.content.push.type.header']}")
    protected String pushTypeHeader;
    protected Map<String, Integer> filterMap = new ConcurrentHashMap<String, Integer>();
    protected Map<String, Integer> readerMap = new ConcurrentHashMap<String, Integer>();
    protected Map<String, Integer> writerMap = new ConcurrentHashMap<String, Integer>();
    protected Map<String, Integer> errorMap = new ConcurrentHashMap<String, Integer>();
    protected Map<Integer, String> appOsMap = new ConcurrentHashMap<Integer, String>();
    protected AtomicInteger readerCount = new AtomicInteger();
    protected AtomicInteger errorCount = new AtomicInteger();
    protected App appInfo;
    protected int maxChunkSize = 10;
    private Random rnd = new Random();
    @Value(value="#{config['use.mgs.public.push']}")
    protected boolean useMgsPublicPush;

    protected boolean checkValidation(PushQueue item) {
        boolean isValid = true;
        if (item.getAppId() == -1 || item.getDeviceId() == -1L) {
            return false;
        }
        return isValid;
    }

    public PushQueue process(PushQueue item) throws Exception {
        this.readerCount.incrementAndGet();
        item.setChunkId(String.format("%02d", this.rnd.nextInt(10) + 1));
        String os = this.appOsMap.get(item.getAppId());
        if (StringUtils.isNull((String)os)) {
            os = "U";
        }
        item.setAppOs(os);
        if (!this.checkValidation(item)) {
            item.setErrorCode("5000");
            this.pushResultService.updatePushQueue(item);
            return null;
        }
        if (this.useMgsPublicPush) {
            item.setSendStatus(StatusType.MQ_SENDING.getCode());
            item.setErrorCode("3001");
        }
        if ("H".equals(item.getPushMessage().getMsgType())) {
            String parsedMsgContent = null;
            if (!StringUtils.isNull((String)item.getPushMessage().getPopupContent())) {
                parsedMsgContent = this.makeRichContents(item.getPushMessage().getPopupContent(), "P", item.getPushMessage().getMsgUid());
                item.getPushMessage().setPopupContent(parsedMsgContent);
            }
            if (!StringUtils.isNull((String)item.getPushMessage().getInAppContent())) {
                parsedMsgContent = this.makeRichContents(item.getPushMessage().getInAppContent(), "M", item.getPushMessage().getMsgUid());
                item.getPushMessage().setInAppContent(parsedMsgContent);
            }
            if (log.isDebugEnabled()) {
                log.debug("item.getPushMessage().getPopupContent() : {}", (Object)item.getPushMessage().getPopupContent());
                log.debug("item.getPushMessage().getInAppContent() : {}", (Object)item.getPushMessage().getInAppContent());
            }
        }
        return item;
    }

    public String makeRichContents(String oriContent, String msgType, String msgId) {
        StringBuilder richContentBuf = new StringBuilder();
        String parsedMsgIdHeader = this.msgIdHeader.replace(MAPPING_MSG_ID_KEYWORD, msgId);
        String richHeadBefore = oriContent.substring(0, oriContent.indexOf(HEAD) + HEAD.length());
        richContentBuf.append(richHeadBefore).append("\n");
        richContentBuf.append(this.charsetHeader);
        richContentBuf.append("\n");
        richContentBuf.append(parsedMsgIdHeader);
        richContentBuf.append("\n");
        richContentBuf.append(this.pushTypeHeader.replace(MAPPING_TYPE_KEYWORD, msgType));
        String richHeadAfter = oriContent.substring(oriContent.indexOf(HEAD) + HEAD.length(), oriContent.length());
        richContentBuf.append(richHeadAfter);
        return richContentBuf.toString();
    }

    public void beforeStep(StepExecution stepExecution) {
        String appGrpKey = stepExecution.getJobExecution().getJobParameters().getString("app.grp.key");
        this.appInfo = this.pushInfoService.getAppInfo(appGrpKey);
        this.appOsMap = this.appInfo.getAppOsMap();
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        if (log.isDebugEnabled()) {
            log.debug("target filter [{}]", (Object)this.filterMap.toString());
        }
        return stepExecution.getExitStatus();
    }
}

