/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.item.database;

import com.humuson.tms.batch.domain.PushQueue;
import com.humuson.tms.batch.item.database.PushSendProcessor;
import com.humuson.tms.constrants.StatusType;
import org.springframework.beans.factory.annotation.Value;

public class PushReSendProcessor
extends PushSendProcessor {
    @Value(value="#{config['use.resend.gcm.for.private.failed']}")
    private boolean useResendGcm;

    @Override
    protected boolean checkValidation(PushQueue item) {
        return true;
    }

    @Override
    public PushQueue process(PushQueue item) throws Exception {
        if (StatusType.PENDDING.getCode().equals(item.getSendStatus())) {
            item.setSendStatus(StatusType.ERROR.getCode());
            item.setErrorCode("7500");
        }
        if (!this.useResendGcm && "3000".equals(item.getErrorCode())) {
            item.setSendStatus(StatusType.ERROR.getCode());
            item.setErrorCode("7500");
        }
        return super.process(item);
    }
}

