/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.item.database;

import com.humuson.tms.batch.domain.ChannelSendType;
import com.humuson.tms.batch.domain.PushResultLog;
import com.humuson.tms.batch.service.UpdateResultService;
import com.humuson.tms.common.util.StringUtils;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;

public class PushQueLogProcessor
implements ItemProcessor<PushResultLog, PushResultLog> {
    private static final Logger log = LoggerFactory.getLogger(PushQueLogProcessor.class);
    private static final String IOS = "I";
    private static final String READ = "R";
    private static final String CLICK = "C";
    private static final String SEND = "S";
    AtomicInteger errorCount = new AtomicInteger();
    private String updateCheckFlag;
    private String selectExistCampClickInfo;
    private String selectExistAutoClickInfo;
    @Autowired
    private UpdateResultService updateResultServiceImpl;

    public PushResultLog process(PushResultLog item) throws Exception {
        if (StringUtils.isNull((String)item.getReqUid()) || StringUtils.isNull((String)item.getType()) || StringUtils.isNull((String)item.getRtnType())) {
            this.errorCount.incrementAndGet();
            item.setCheckFlag("F");
            this.updateResultServiceImpl.updateCheckFlag(this.updateCheckFlag, item);
            return null;
        }
        if (!item.getType().startsWith("CC") && !item.getType().startsWith("AA")) {
            this.errorCount.incrementAndGet();
            item.setCheckFlag("F");
            this.updateResultServiceImpl.updateCheckFlag(this.updateCheckFlag, item);
            return null;
        }
        String postId = item.getPostId();
        if (item.getChannelSendType().equals((Object)ChannelSendType.AUTO) && !StringUtils.isNull((String)postId)) {
            int pos = postId.lastIndexOf(95);
            item.setWorkday(postId.substring(0, pos));
            item.setSeqNo(postId.substring(pos + 1));
        }
        if (SEND.equals(item.getRtnType())) {
            item.setPushedCnt(1);
            if (!"00".equals(item.getErrorCode())) {
                item.setFailCnt(1);
            }
        } else if (READ.equals(item.getRtnType())) {
            item.setOpenCnt(1);
            item.setErrorCode("");
            if (IOS.equals(item.getAppOs())) {
                item.setOpenCntIos(1);
            } else {
                item.setOpenCntAndroid(1);
            }
        } else if (CLICK.equals(item.getRtnType())) {
            int existCount = item.getChannelSendType().equals((Object)ChannelSendType.AUTO) ? this.updateResultServiceImpl.alreadExistClickInfo(this.selectExistAutoClickInfo, new BeanPropertySqlParameterSource((Object)item)) : this.updateResultServiceImpl.alreadExistClickInfo(this.selectExistCampClickInfo, new BeanPropertySqlParameterSource((Object)item));
            if (existCount > 0) {
                item.setDupClickCnt(1);
            } else {
                item.setClickCnt(1);
                item.setDupClickCnt(1);
                if (IOS.equals(item.getAppOs())) {
                    item.setClickCntIos(1);
                } else {
                    item.setClickCntAndroid(1);
                }
            }
            item.setErrorCode("");
        }
        if (log.isDebugEnabled()) {
            log.debug("item :{}", (Object)item.toString());
        }
        return item;
    }

    public void setUpdateCheckFlag(String updateCheckFlag) {
        this.updateCheckFlag = updateCheckFlag;
    }

    public void setSelectExistCampClickInfo(String selectExistCampClickInfo) {
        this.selectExistCampClickInfo = selectExistCampClickInfo;
    }

    public void setSelectExistAutoClickInfo(String selectExistAutoClickInfo) {
        this.selectExistAutoClickInfo = selectExistAutoClickInfo;
    }
}

