/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.item.database;

import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.domain.PushResult;
import com.humuson.tms.batch.service.MqProducer;
import com.humuson.tms.batch.service.PushInfoService;
import com.humuson.tms.batch.service.PushResultService;
import com.humuson.tms.mq.model.MgsPush;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class PushFeedbackItemWriter
implements ItemWriter<PushResult> {
    private static final Logger log = LoggerFactory.getLogger(PushFeedbackItemWriter.class);
    protected static final String USE = "Y";
    @Autowired
    protected PushResultService pushResultService;
    @Autowired
    @Qualifier(value="mqCampResProducer")
    private MqProducer mqCampResProducer;
    @Autowired
    @Qualifier(value="mqAutoResProducer")
    private MqProducer mqAutoResProducer;
    @Autowired
    protected PushInfoService<App, PushMessage> pushInfoService;

    public void write(List<? extends PushResult> rawData) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("feedback write size : {}", (Object)rawData.size());
        }
        ArrayList<PushResult> prvPushResultList = new ArrayList<PushResult>();
        prvPushResultList.addAll(rawData);
        ArrayList<Object[]> prvPushMqDeleteList = new ArrayList<Object[]>();
        String appKey = this.pushInfoService.selectAndroidAppKeyByAppGrpId(((PushResult)prvPushResultList.get(0)).getAppGrpId());
        MgsPush.Response.Builder mqAutoResponseBuilder = MgsPush.Response.newBuilder();
        MgsPush.Response.Builder mqCampResponseBuilder = MgsPush.Response.newBuilder();
        MgsPush.Response.ResponsePayload.Builder responsePayloadBuilder = MgsPush.Response.ResponsePayload.newBuilder();
        Iterator it = prvPushResultList.iterator();
        while (it.hasNext()) {
            PushResult result = (PushResult)it.next();
            if (!result.isMqSending()) continue;
            it.remove();
            responsePayloadBuilder.clear();
            responsePayloadBuilder.setId(result.getPushId() + "&&" + result.getDeviceId() + "&&" + result.getReqUid() + "&&" + result.getCustId());
            responsePayloadBuilder.setReturnCode(MgsPush.Response.ReturnCode.SUCCESSFUL);
            responsePayloadBuilder.setServerId(result.getServerId());
            if (result.getReqUid().startsWith("AA")) {
                mqAutoResponseBuilder.addResPayload(responsePayloadBuilder.build());
            } else if (result.getReqUid().startsWith("CC")) {
                mqCampResponseBuilder.addResPayload(responsePayloadBuilder.build());
            }
            prvPushMqDeleteList.add(new Object[]{result.getReqUid()});
        }
        if (!mqAutoResponseBuilder.getResPayloadList().isEmpty()) {
            mqAutoResponseBuilder.setResultCode(MgsPush.Response.ResultCode.SUCCESS);
            mqAutoResponseBuilder.setAppKey(appKey);
            mqAutoResponseBuilder.setPushChnType(MgsPush.PushChnType.GCM);
            this.mqAutoResProducer.send(mqAutoResponseBuilder.build());
        }
        if (!mqCampResponseBuilder.getResPayloadList().isEmpty()) {
            mqCampResponseBuilder.setResultCode(MgsPush.Response.ResultCode.SUCCESS);
            mqCampResponseBuilder.setAppKey(appKey);
            mqCampResponseBuilder.setPushChnType(MgsPush.PushChnType.GCM);
            this.mqCampResProducer.send(mqCampResponseBuilder.build());
        }
        if (!prvPushResultList.isEmpty()) {
            this.pushResultService.batchUpdatePushResult(prvPushResultList);
        }
        if (!prvPushMqDeleteList.isEmpty()) {
            this.pushResultService.deleteMqResendList(prvPushMqDeleteList);
        }
    }
}

