/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.item.database;

import com.humuson.tms.batch.domain.PushResult;
import com.humuson.tms.batch.service.PushResultService;
import com.humuson.tms.constrants.StatusType;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.beans.factory.annotation.Autowired;

public class PrvFeedbackProcessor
implements ItemProcessor<PushResult, PushResult>,
StepExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(PrvFeedbackProcessor.class);
    @Autowired
    protected PushResultService pushResultService;
    protected AtomicInteger readerCount = new AtomicInteger();
    protected AtomicInteger errorCount = new AtomicInteger();
    protected AtomicInteger writerCount = new AtomicInteger();

    public PushResult process(PushResult item) throws Exception {
        this.readerCount.incrementAndGet();
        if (StatusType.ERROR.getCode().equals(item.getSendStatus())) {
            this.errorCount.incrementAndGet();
            return null;
        }
        this.writerCount.incrementAndGet();
        return item;
    }

    public void beforeStep(StepExecution stepExecution) {
        log.info("private feedback beforeStep");
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        log.info("private feedback [read:{}, error:{}, writer:{}]", new Object[]{this.readerCount.get(), this.errorCount.get(), this.writerCount.get()});
        return stepExecution.getExitStatus();
    }
}

