/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.item.database;

import com.humuson.tms.batch.service.SystemCodeService;
import com.humuson.tms.common.model.target.TargetData;
import com.humuson.tms.common.security.HumusonDecryptor;
import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.constrants.ChannelType;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class OptmzTargetProcessor
implements ItemProcessor<TargetData, TargetData>,
StepExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(OptmzTargetProcessor.class);
    protected String chnType;
    protected String postId;
    protected String targetType;
    protected String idTargetYn;
    protected String deduplicationYn;
    protected String msgId;
    protected Long siteId;
    private int maxChunkSize = 10;
    private Random rnd = new Random();
    @Value(value="#{config['tms.db.enc.key']}")
    protected String encKey;
    protected String dbEncryptFlag;
    @Autowired
    SystemCodeService systemCodeServiceImpl;

    public TargetData process(TargetData item) throws Exception {
        if (ChannelType.EMAIL.getCode().equals(this.chnType)) {
            String email = item.getMemberEmail();
            if (StringUtils.isNull((String)email)) {
                return null;
            }
            if ("Y".equals(this.dbEncryptFlag)) {
                try {
                    email = HumusonDecryptor.decrypt((String)email, (String)this.encKey, (boolean)false);
                }
                catch (Exception e) {
                    log.error("email decrypt fail {}", (Object)email);
                }
            }
            if (StringUtils.isEmailError((String)email)) {
                return null;
            }
            item.setDomain(StringUtils.getDomain((String)email));
        } else if (ChannelType.PUSH.getCode().equals(this.chnType)) {
            if (StringUtils.isNull((String)item.getMemberToken()) || StringUtils.isNull((String)item.getDeviceId())) {
                if (log.isDebugEnabled()) {
                    log.debug("pushToken or deviceId is null [{}]", (Object)item.toString());
                }
                return null;
            }
        } else if (ChannelType.SMS.getCode().equals(this.chnType)) {
            String phone = item.getMemberPhone();
            if (StringUtils.isNull((String)phone)) {
                return null;
            }
            if ("Y".equals(this.dbEncryptFlag)) {
                try {
                    phone = HumusonDecryptor.decrypt((String)phone, (String)this.encKey, (boolean)false);
                }
                catch (Exception e) {
                    log.error("phone decrypt fail {}", (Object)phone);
                }
            }
            if (StringUtils.isSmsError((String)phone)) {
                return null;
            }
            item.setTelCode(StringUtils.getTeleCom((String)phone));
        }
        item.setChannelType(this.chnType).setPostId(this.postId).setChunkId(String.valueOf(this.rnd.nextInt(this.maxChunkSize))).setMsgId(this.msgId);
        if ("Y".equals(this.deduplicationYn)) {
            if (ChannelType.EMAIL.getCode().equals(this.chnType)) {
                item.setDuplicateKey(item.getMemberEmail());
            } else if (ChannelType.SMS.getCode().equals(this.chnType)) {
                item.setDuplicateKey(item.getMemberPhone());
            } else if (ChannelType.PUSH.getCode().equals(this.chnType)) {
                item.setDuplicateKey(item.getDeviceId());
            }
        }
        return item;
    }

    public void beforeStep(StepExecution stepExecution) {
        this.chnType = stepExecution.getJobParameters().getString("chn.type");
        this.msgId = stepExecution.getJobParameters().getString("msg.id");
        this.postId = stepExecution.getJobParameters().getString("post.id");
        this.siteId = stepExecution.getJobParameters().getLong("site.id");
        log.info("chnType:{}, siteId:{}, postId:{}", new Object[]{this.chnType, this.siteId, this.postId});
        this.dbEncryptFlag = this.systemCodeServiceImpl.getDbEncryptYn();
        this.deduplicationYn = stepExecution.getJobParameters().getString("deduplication.yn", "N");
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        return stepExecution.getExitStatus();
    }
}

