/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.item.database;

import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.DirectQueue;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.service.PushInfoService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

public class DirectPushSendProcessor
implements ItemProcessor<DirectQueue, DirectQueue>,
StepExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(DirectPushSendProcessor.class);
    protected App appInfo;
    protected Map<Integer, String> appOsMap = new ConcurrentHashMap<Integer, String>();
    @Autowired
    protected PushInfoService<App, PushMessage> pushInfoService;
    @Autowired
    protected JdbcTemplate jdbcTemplate;

    protected boolean checkValidation(DirectQueue item) {
        return true;
    }

    public void beforeStep(StepExecution stepExecution) {
        String appGrpKey = stepExecution.getJobExecution().getJobParameters().getString("app.grp.key");
        this.appInfo = this.pushInfoService.getAppInfo(appGrpKey);
        this.appOsMap = this.appInfo.getAppOsMap();
    }

    public DirectQueue process(DirectQueue item) throws Exception {
        if (!this.checkValidation(item)) {
            log.error("[DIRECT] check validation error []", (Object)item.toString());
            return null;
        }
        return item;
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        return stepExecution.getExitStatus();
    }
}

