/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.item.database;

import com.humuson.amc.client.AmcClient;
import com.humuson.amc.client.model.Page;
import com.humuson.amc.client.model.request.ContactRequest;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.database.AbstractPagingItemReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class AmcApiPagingItemReader<T>
extends AbstractPagingItemReader<T>
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AmcApiPagingItemReader.class);
    private AmcClient client;
    private String amcSiteKey;
    private String amcChannelKey;
    private int audienceSeq;
    private int requestTimeoutMillisecond = -1;

    public void afterPropertiesSet() throws Exception {
        this.client = new AmcClient.Builder().setBaseUri("http://119.207.76.91:7082/api").build();
    }

    protected void doReadPage() {
        List result;
        if (this.results == null) {
            this.results = new CopyOnWriteArrayList();
        } else {
            this.results.clear();
        }
        ContactRequest request = new ContactRequest();
        request.setSize(this.getPageSize());
        request.setPage(this.getPage() + 1);
        request.setAudienceSeq(String.valueOf(this.audienceSeq));
        if (this.requestTimeoutMillisecond != -1 && this.requestTimeoutMillisecond >= 0) {
            request.setTimeout(Integer.valueOf(20000));
        }
        long start = System.currentTimeMillis();
        Object response = null;
        log.info("elapse time : {}", (Object)(System.currentTimeMillis() - start));
        Assert.isTrue((200 == response.getCode() ? 1 : 0) != 0, (String)("Http Request Fail Retrun code : [" + response.getCode() + "] / Error Msg : [" + response.getMsg() + "]"));
        if (response.get() != null && (result = ((Page)response.get()).getContent()) != null) {
            this.results.addAll(result);
        }
    }

    protected void doJumpToPage(int itemIndex) {
    }

    public void setAmcSiteKey(String amcSiteKey) {
        this.amcSiteKey = amcSiteKey;
    }

    public void setAmcChannelKey(String amcChannelKey) {
        this.amcChannelKey = amcChannelKey;
    }

    public void setAudienceSeq(int audienceSeq) {
        this.audienceSeq = audienceSeq;
    }

    public void setRequestTimeoutMillisecond(int requestTimeoutMillisecond) {
        this.requestTimeoutMillisecond = requestTimeoutMillisecond;
    }
}

