/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.item.database;

import com.humuson.amc.client.AmcClient;
import com.humuson.amc.client.model.IteratorResponse;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.util.ClassUtils;

public abstract class AmcAbstractIterateItemReader<T, R, C>
extends AbstractItemCountingItemStreamItemReader<R> {
    private static final Logger log = LoggerFactory.getLogger(AmcAbstractIterateItemReader.class);
    protected AmcClient client;
    private String baseUrl;
    protected String amcSiteKey;
    protected String amcChannelKey;
    protected int getItemSize;
    T request;
    protected IteratorResponse<C> response = null;
    private volatile boolean initialized = false;
    private volatile int current = 0;
    Object lock = new Object();
    protected int requestTimeoutMillisecond = 5000;
    protected volatile List<R> results;

    public AmcAbstractIterateItemReader() {
        this.setName(ClassUtils.getShortName(AmcAbstractIterateItemReader.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected R doRead() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            int next;
            if (this.results == null || this.results.isEmpty()) {
                this.apiRead();
                this.response = this.response.next();
                if (this.current >= this.getItemSize) {
                    this.current = 0;
                }
            }
            if ((next = this.current++) < this.results.size()) {
                return this.results.get(next);
            }
            return null;
        }
    }

    protected abstract void apiRead();

    protected abstract void initRequestData();

    protected void doOpen() throws Exception {
        this.client = this.baseUrl != null ? new AmcClient.Builder().setBaseUri(this.baseUrl).build() : new AmcClient.Builder().setBaseUri("http://119.207.76.91:7082/api").build();
        this.initRequestData();
    }

    protected void doClose() throws Exception {
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setAmcSiteKey(String amcSiteKey) {
        this.amcSiteKey = amcSiteKey;
    }

    public void setAmcChannelKey(String amcChannelKey) {
        this.amcChannelKey = amcChannelKey;
    }

    public void setGetItemSize(int getItemSize) {
        this.getItemSize = getItemSize;
    }

    public void setRequestTimeoutMillisecond(int requestTimeoutMillisecond) {
        this.requestTimeoutMillisecond = requestTimeoutMillisecond;
    }
}

