/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.item.apns;

import com.humuson.tms.batch.domain.ApnsFeedback;
import com.humuson.tms.batch.service.AppUserRemover;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;

public class ApnsFeedbackItemWriter
implements ItemWriter<ApnsFeedback> {
    private static final Logger log = LoggerFactory.getLogger(ApnsFeedbackItemWriter.class);
    protected static final String USE = "Y";
    @Autowired
    protected AppUserRemover appUserRemover;

    public void write(List<? extends ApnsFeedback> rawData) throws Exception {
        try {
            int[] updateIds = this.appUserRemover.updateIosUnActiveToken(rawData);
            log.info("APNS Feedback Update Count :{}", (Object)updateIds.length);
        }
        catch (Exception e) {
            log.error("APNS Feedback Batch Update fail", (Throwable)e);
            for (ApnsFeedback feedback : rawData) {
                try {
                    this.appUserRemover.updateIosUnActiveToken(feedback);
                }
                catch (Exception e2) {
                    log.error("APNS Feedback err [grpId:{}, token:{}]", (Object)feedback.getGrpId(), (Object)feedback.getUuid());
                }
            }
        }
    }
}

