/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.item.apns;

import com.humuson.tms.batch.domain.ApnsFeedback;
import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.service.PushInfoService;
import com.humuson.tms.common.security.HumusonDecryptor;
import com.humuson.tms.common.util.FileUtil;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javapns.Push;
import javapns.devices.Device;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ItemReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public class ApnsFeedbackItemReader
implements ItemReader<ApnsFeedback>,
StepExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(ApnsFeedbackItemReader.class);
    private List<ApnsFeedback> results;
    private int currentReadCount = 0;
    private int currentItemCount = 0;
    private int maxItemCount = Integer.MAX_VALUE;
    @Value(value="#{config['tms.db.enc.key']}")
    protected String encKey;
    protected App appInfo;
    @Autowired
    private PushInfoService<App, PushMessage> pushInfoServiceImpl;

    public void beforeStep(StepExecution stepExecution) {
        String appGrpKey = stepExecution.getJobParameters().getString("app.grp.key");
        this.appInfo = this.pushInfoServiceImpl.getAppInfo(appGrpKey);
        log.info("appInfo : {}", (Object)this.appInfo.toString());
    }

    public ApnsFeedback read() throws Exception {
        if (this.currentItemCount >= this.maxItemCount) {
            return null;
        }
        return this.doRead();
    }

    private synchronized ApnsFeedback doRead() throws Exception {
        if (this.results == null || this.currentReadCount >= this.currentItemCount) {
            this.doMoreFeedbackList();
            if (this.results != null && log.isDebugEnabled()) {
                log.debug("reader size : {}", (Object)this.currentItemCount);
            }
        }
        int next = this.currentReadCount++;
        if (this.results != null && next < this.results.size()) {
            return this.results.get(next);
        }
        return null;
    }

    private void doMoreFeedbackList() {
        if (this.results == null) {
            this.results = new CopyOnWriteArrayList<ApnsFeedback>();
            this.currentItemCount = 0;
        }
        String apnsCert = this.appInfo.getApnsPushCert();
        String apnsPwd = this.appInfo.getApnsPushPwd();
        if (!StringUtils.isEmpty((Object)apnsCert) && !StringUtils.isEmpty((Object)apnsPwd)) {
            if (FileUtil.isValidFile((String)apnsCert)) {
                try {
                    apnsPwd = HumusonDecryptor.decrypt((String)apnsPwd, (String)this.encKey);
                }
                catch (Exception e) {
                    log.error("HumusonDecryptor exception : {}", (Throwable)e);
                }
                try {
                    List feedbackList = Push.feedback((Object)apnsCert, (String)apnsPwd, (boolean)true);
                    for (Device device : feedbackList) {
                        log.debug("APNS Feedback [appGrpId:{}, token:{}, deviceId:{}]", new Object[]{this.appInfo.getAppGrpId(), device.getToken(), device.getDeviceId()});
                        this.results.add(new ApnsFeedback(this.appInfo.getAppGrpId(), device.getToken()));
                        ++this.currentItemCount;
                    }
                }
                catch (Exception e) {
                    log.error("Apns error[apnsCert:{}, apnsPwd:{}] : {}", new Object[]{apnsCert, apnsPwd, e});
                }
            } else {
                log.error("apns p12 file validation error [file:{}, pwd:{}]", (Object)apnsCert, (Object)apnsPwd);
            }
        } else {
            log.error("apns file or pwd is null");
            throw new NullPointerException("apns file or pwd is null");
        }
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        log.info("APNS Feedback read count : {}, currentReadCount : {}, currentItemCount : {} result size : {}", new Object[]{stepExecution.getReadCount(), this.currentReadCount, this.currentItemCount, this.results == null ? 0 : this.results.size()});
        return stepExecution.getExitStatus();
    }
}

