/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.integration.transformer;

import com.humuson.tms.batch.integration.transformer.MessageToJobRequest;
import com.humuson.tms.mq.model.JobRequest;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.integration.launch.JobLaunchRequest;

public class JmsMessageToJobRequest
implements MessageToJobRequest {
    private static final Logger log = LoggerFactory.getLogger(JmsMessageToJobRequest.class);
    private JobRegistry jobRegistry;

    public JmsMessageToJobRequest(JobRegistry jobRegistry) {
        this.jobRegistry = jobRegistry;
    }

    @Override
    public JobLaunchRequest toRequest(JobRequest request) {
        JobParametersBuilder builder = new JobParametersBuilder();
        log.info("toRequest :{}", (Object)request.toString());
        Job job = null;
        try {
            job = this.jobRegistry.getJob(request.getJobName());
            Map param = request.getJobParameter();
            for (String key : param.keySet()) {
                Object value = param.get(key);
                if (value instanceof Long) {
                    builder.addLong(key, (Long)value);
                    continue;
                }
                if (value instanceof String) {
                    builder.addString(key, String.valueOf(value));
                    continue;
                }
                log.error("unknown instance [key:{}, value:{}]", (Object)key, value);
            }
            return new JobLaunchRequest(job, builder.toJobParameters());
        }
        catch (NoSuchJobException e) {
            if (request.getJobName() == null) {
                log.error("Request Job name is null", (Throwable)e);
            } else {
                log.error("NoSuchJobException [{}]", (Object)request.getJobName(), (Object)e);
            }
            return null;
        }
    }
}

