/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.domain;

import com.humuson.tms.constrants.StatusType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushResult {
    private static final Logger log = LoggerFactory.getLogger(PushResult.class);
    public static final int MAX_CHUNK_SIZE = 10;
    private Random rnd = new Random();
    private int appGrpId;
    private String rowId;
    private Long pushId;
    private int deviceId;
    private String reqUid;
    private String custId = "";
    private String errorCode;
    private String changedToken;
    private String appOs;
    private String sendStatus;
    private String resultData;
    private String resDate;
    private String rtnType = "S";
    private String chunkId;
    private String sendTime;
    private String recvTime;
    private boolean isMqSending = false;
    private String serverId;

    public PushResult(int appGrpId, String errorCode, String id, String appOs, String rowId) {
        this.appGrpId = appGrpId;
        this.errorCode = errorCode;
        if (id.indexOf("&&") >= 0) {
            String[] ids = id.split("&&");
            try {
                this.pushId = Long.parseLong(ids[0]);
            }
            catch (Exception e) {
                this.isMqSending = true;
                this.serverId = id.split(":")[1];
            }
            this.deviceId = Integer.parseInt(ids[1]);
            this.reqUid = ids[2];
            if (ids.length > 3) {
                this.custId = ids[3].split(":").length > 1 ? ids[3].split(":")[0] : ids[3];
            }
        } else if (id.indexOf("AA") >= 0 && id.indexOf("_") >= 0) {
            String[] ids = id.split("_");
            try {
                this.pushId = Long.parseLong(ids[0]);
            }
            catch (Exception e) {
                this.isMqSending = true;
            }
            this.deviceId = Integer.parseInt(ids[1]);
            this.reqUid = ids[2] + "_" + ids[3] + "_" + ids[4];
            if (ids.length > 5) {
                this.custId = ids[5];
            }
        } else if (id.indexOf("_") >= 0) {
            String[] ids = id.split("_");
            try {
                this.pushId = Long.parseLong(ids[0]);
            }
            catch (Exception e) {
                this.isMqSending = true;
            }
            this.deviceId = Integer.parseInt(ids[1]);
            if (ids.length <= 4) {
                this.reqUid = ids[2];
                if (ids.length > 3) {
                    this.custId = ids[3];
                }
            } else {
                this.reqUid = ids[2] + ids[3];
                if (ids.length > 5) {
                    this.custId = ids[4] + ids[5];
                }
            }
        }
        this.chunkId = String.format("%02d", this.rnd.nextInt(10) + 1);
        this.appOs = appOs;
        this.sendStatus = "3000".equals(errorCode) ? StatusType.SENDING.getCode() : ("3001".equals(errorCode) ? StatusType.MQ_SENDING.getCode() : ("3002".equals(errorCode) ? StatusType.CCS_SENDING.getCode() : ("0000".equals(errorCode) || "1000".equals(errorCode) ? StatusType.COMPLETE.getCode() : StatusType.ERROR.getCode())));
        if (rowId != null && !"".equals(rowId)) {
            this.rowId = rowId;
        }
    }

    public String getErrorCode() {
        if ("0000".equals(this.errorCode) || "1000".equals(this.errorCode)) {
            this.errorCode = "1000";
        }
        return this.errorCode;
    }

    public Map<String, Object> toMap() {
        Field[] fields;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                map.put(field.getName(), field.get(this));
            }
            catch (IllegalArgumentException e) {
                log.error("IllegalArgumentException", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error("IllegalAccessException", (Throwable)e);
            }
        }
        return map;
    }

    public Random getRnd() {
        return this.rnd;
    }

    public int getAppGrpId() {
        return this.appGrpId;
    }

    public String getRowId() {
        return this.rowId;
    }

    public Long getPushId() {
        return this.pushId;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public String getReqUid() {
        return this.reqUid;
    }

    public String getCustId() {
        return this.custId;
    }

    public String getChangedToken() {
        return this.changedToken;
    }

    public String getAppOs() {
        return this.appOs;
    }

    public String getSendStatus() {
        return this.sendStatus;
    }

    public String getResultData() {
        return this.resultData;
    }

    public String getResDate() {
        return this.resDate;
    }

    public String getRtnType() {
        return this.rtnType;
    }

    public String getChunkId() {
        return this.chunkId;
    }

    public String getSendTime() {
        return this.sendTime;
    }

    public String getRecvTime() {
        return this.recvTime;
    }

    public boolean isMqSending() {
        return this.isMqSending;
    }

    public String getServerId() {
        return this.serverId;
    }

    public PushResult setRnd(Random rnd) {
        this.rnd = rnd;
        return this;
    }

    public PushResult setAppGrpId(int appGrpId) {
        this.appGrpId = appGrpId;
        return this;
    }

    public PushResult setRowId(String rowId) {
        this.rowId = rowId;
        return this;
    }

    public PushResult setPushId(Long pushId) {
        this.pushId = pushId;
        return this;
    }

    public PushResult setDeviceId(int deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public PushResult setReqUid(String reqUid) {
        this.reqUid = reqUid;
        return this;
    }

    public PushResult setCustId(String custId) {
        this.custId = custId;
        return this;
    }

    public PushResult setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public PushResult setChangedToken(String changedToken) {
        this.changedToken = changedToken;
        return this;
    }

    public PushResult setAppOs(String appOs) {
        this.appOs = appOs;
        return this;
    }

    public PushResult setSendStatus(String sendStatus) {
        this.sendStatus = sendStatus;
        return this;
    }

    public PushResult setResultData(String resultData) {
        this.resultData = resultData;
        return this;
    }

    public PushResult setResDate(String resDate) {
        this.resDate = resDate;
        return this;
    }

    public PushResult setRtnType(String rtnType) {
        this.rtnType = rtnType;
        return this;
    }

    public PushResult setChunkId(String chunkId) {
        this.chunkId = chunkId;
        return this;
    }

    public PushResult setSendTime(String sendTime) {
        this.sendTime = sendTime;
        return this;
    }

    public PushResult setRecvTime(String recvTime) {
        this.recvTime = recvTime;
        return this;
    }

    public PushResult setMqSending(boolean isMqSending) {
        this.isMqSending = isMqSending;
        return this;
    }

    public PushResult setServerId(String serverId) {
        this.serverId = serverId;
        return this;
    }

    public String toString() {
        return "PushResult(rnd=" + this.getRnd() + ", appGrpId=" + this.getAppGrpId() + ", rowId=" + this.getRowId() + ", pushId=" + this.getPushId() + ", deviceId=" + this.getDeviceId() + ", reqUid=" + this.getReqUid() + ", custId=" + this.getCustId() + ", errorCode=" + this.getErrorCode() + ", changedToken=" + this.getChangedToken() + ", appOs=" + this.getAppOs() + ", sendStatus=" + this.getSendStatus() + ", resultData=" + this.getResultData() + ", resDate=" + this.getResDate() + ", rtnType=" + this.getRtnType() + ", chunkId=" + this.getChunkId() + ", sendTime=" + this.getSendTime() + ", recvTime=" + this.getRecvTime() + ", isMqSending=" + this.isMqSending() + ", serverId=" + this.getServerId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PushResult)) {
            return false;
        }
        PushResult other = (PushResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Random this$rnd = this.getRnd();
        Random other$rnd = other.getRnd();
        if (this$rnd == null ? other$rnd != null : !this$rnd.equals(other$rnd)) {
            return false;
        }
        if (this.getAppGrpId() != other.getAppGrpId()) {
            return false;
        }
        String this$rowId = this.getRowId();
        String other$rowId = other.getRowId();
        if (this$rowId == null ? other$rowId != null : !this$rowId.equals(other$rowId)) {
            return false;
        }
        Long this$pushId = this.getPushId();
        Long other$pushId = other.getPushId();
        if (this$pushId == null ? other$pushId != null : !((Object)this$pushId).equals(other$pushId)) {
            return false;
        }
        if (this.getDeviceId() != other.getDeviceId()) {
            return false;
        }
        String this$reqUid = this.getReqUid();
        String other$reqUid = other.getReqUid();
        if (this$reqUid == null ? other$reqUid != null : !this$reqUid.equals(other$reqUid)) {
            return false;
        }
        String this$custId = this.getCustId();
        String other$custId = other.getCustId();
        if (this$custId == null ? other$custId != null : !this$custId.equals(other$custId)) {
            return false;
        }
        String this$errorCode = this.getErrorCode();
        String other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) {
            return false;
        }
        String this$changedToken = this.getChangedToken();
        String other$changedToken = other.getChangedToken();
        if (this$changedToken == null ? other$changedToken != null : !this$changedToken.equals(other$changedToken)) {
            return false;
        }
        String this$appOs = this.getAppOs();
        String other$appOs = other.getAppOs();
        if (this$appOs == null ? other$appOs != null : !this$appOs.equals(other$appOs)) {
            return false;
        }
        String this$sendStatus = this.getSendStatus();
        String other$sendStatus = other.getSendStatus();
        if (this$sendStatus == null ? other$sendStatus != null : !this$sendStatus.equals(other$sendStatus)) {
            return false;
        }
        String this$resultData = this.getResultData();
        String other$resultData = other.getResultData();
        if (this$resultData == null ? other$resultData != null : !this$resultData.equals(other$resultData)) {
            return false;
        }
        String this$resDate = this.getResDate();
        String other$resDate = other.getResDate();
        if (this$resDate == null ? other$resDate != null : !this$resDate.equals(other$resDate)) {
            return false;
        }
        String this$rtnType = this.getRtnType();
        String other$rtnType = other.getRtnType();
        if (this$rtnType == null ? other$rtnType != null : !this$rtnType.equals(other$rtnType)) {
            return false;
        }
        String this$chunkId = this.getChunkId();
        String other$chunkId = other.getChunkId();
        if (this$chunkId == null ? other$chunkId != null : !this$chunkId.equals(other$chunkId)) {
            return false;
        }
        String this$sendTime = this.getSendTime();
        String other$sendTime = other.getSendTime();
        if (this$sendTime == null ? other$sendTime != null : !this$sendTime.equals(other$sendTime)) {
            return false;
        }
        String this$recvTime = this.getRecvTime();
        String other$recvTime = other.getRecvTime();
        if (this$recvTime == null ? other$recvTime != null : !this$recvTime.equals(other$recvTime)) {
            return false;
        }
        if (this.isMqSending() != other.isMqSending()) {
            return false;
        }
        String this$serverId = this.getServerId();
        String other$serverId = other.getServerId();
        return !(this$serverId == null ? other$serverId != null : !this$serverId.equals(other$serverId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PushResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Random $rnd = this.getRnd();
        result = result * 59 + ($rnd == null ? 0 : $rnd.hashCode());
        result = result * 59 + this.getAppGrpId();
        String $rowId = this.getRowId();
        result = result * 59 + ($rowId == null ? 0 : $rowId.hashCode());
        Long $pushId = this.getPushId();
        result = result * 59 + ($pushId == null ? 0 : ((Object)$pushId).hashCode());
        result = result * 59 + this.getDeviceId();
        String $reqUid = this.getReqUid();
        result = result * 59 + ($reqUid == null ? 0 : $reqUid.hashCode());
        String $custId = this.getCustId();
        result = result * 59 + ($custId == null ? 0 : $custId.hashCode());
        String $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 0 : $errorCode.hashCode());
        String $changedToken = this.getChangedToken();
        result = result * 59 + ($changedToken == null ? 0 : $changedToken.hashCode());
        String $appOs = this.getAppOs();
        result = result * 59 + ($appOs == null ? 0 : $appOs.hashCode());
        String $sendStatus = this.getSendStatus();
        result = result * 59 + ($sendStatus == null ? 0 : $sendStatus.hashCode());
        String $resultData = this.getResultData();
        result = result * 59 + ($resultData == null ? 0 : $resultData.hashCode());
        String $resDate = this.getResDate();
        result = result * 59 + ($resDate == null ? 0 : $resDate.hashCode());
        String $rtnType = this.getRtnType();
        result = result * 59 + ($rtnType == null ? 0 : $rtnType.hashCode());
        String $chunkId = this.getChunkId();
        result = result * 59 + ($chunkId == null ? 0 : $chunkId.hashCode());
        String $sendTime = this.getSendTime();
        result = result * 59 + ($sendTime == null ? 0 : $sendTime.hashCode());
        String $recvTime = this.getRecvTime();
        result = result * 59 + ($recvTime == null ? 0 : $recvTime.hashCode());
        result = result * 59 + (this.isMqSending() ? 79 : 97);
        String $serverId = this.getServerId();
        result = result * 59 + ($serverId == null ? 0 : $serverId.hashCode());
        return result;
    }
}

