/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.batch.benchmark;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;

public class InsertDummyUserTasklet
implements Tasklet {
    private static Logger logger = LoggerFactory.getLogger(InsertDummyUserTasklet.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private String insertDummyUser = "INSERT INTO TMS_APP_DEVICE_LIST( SITE_ID, APP_GRP_ID, APP_ID, CUST_ID, UUID, TOKEN, NOTI_FLAG, BMKT_FLAG,OS, REG_DATE ) values ( 13, 110, 97, ?, ?, ?, 'Y', 'Y', 'A', NOW() )";
    private int gengerateUserCount = 500000;
    private int commitCount = 1000;

    public RepeatStatus execute(StepContribution stepContribution, ChunkContext chunkContext) throws Exception {
        logger.info("Start InsertDummyUserTask");
        int startIdx = 0;
        logger.info("insert dummy app user");
        for (int i = 1; i <= this.gengerateUserCount; ++i) {
            if (i > 0 && i % this.commitCount == 0) {
                try {
                    this.insertAppUser(startIdx);
                    logger.info("insert app user : {}", (Object)startIdx);
                }
                catch (Exception e) {
                    logger.info("error : {}", (Throwable)e);
                }
            }
            ++startIdx;
        }
        logger.info(" insert app user count : {}", (Object)startIdx);
        return RepeatStatus.FINISHED;
    }

    private void insertAppUser(final int startIdx) {
        BatchPreparedStatementSetter dummyUserSetter = new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                ps.setString(1, "tms-" + (startIdx + i));
                ps.setString(2, "uuid-" + (startIdx + i));
                ps.setString(3, "token-" + (startIdx + i));
            }

            public int getBatchSize() {
                return InsertDummyUserTasklet.this.commitCount;
            }
        };
        this.jdbcTemplate.batchUpdate(this.insertDummyUser, dummyUserSetter);
    }
}

