/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gcm.server;

import com.google.android.gcm.server.Notification;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Message
implements Serializable {
    private static final long serialVersionUID = 1897824104011291832L;
    private final String collapseKey;
    private final Boolean delayWhileIdle;
    private final Integer timeToLive;
    private final Map<String, String> data;
    private final Boolean dryRun;
    private final String restrictedPackageName;
    private final String priority;
    private final Notification notification;

    private Message(Builder builder) {
        this.collapseKey = builder.collapseKey;
        this.delayWhileIdle = builder.delayWhileIdle;
        this.data = Collections.unmodifiableMap(builder.data);
        this.timeToLive = builder.timeToLive;
        this.dryRun = builder.dryRun;
        this.restrictedPackageName = builder.restrictedPackageName;
        this.priority = builder.priority;
        this.notification = builder.notification;
    }

    public String getCollapseKey() {
        return this.collapseKey;
    }

    public Boolean isDelayWhileIdle() {
        return this.delayWhileIdle;
    }

    public Integer getTimeToLive() {
        return this.timeToLive;
    }

    public Boolean isDryRun() {
        return this.dryRun;
    }

    public String getRestrictedPackageName() {
        return this.restrictedPackageName;
    }

    public String getPriority() {
        return this.priority;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public Notification getNotification() {
        return this.notification;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Message(");
        if (this.priority != null) {
            builder.append("priority=").append(this.priority).append(", ");
        }
        if (this.collapseKey != null) {
            builder.append("collapseKey=").append(this.collapseKey).append(", ");
        }
        if (this.timeToLive != null) {
            builder.append("timeToLive=").append(this.timeToLive).append(", ");
        }
        if (this.delayWhileIdle != null) {
            builder.append("delayWhileIdle=").append(this.delayWhileIdle).append(", ");
        }
        if (this.dryRun != null) {
            builder.append("dryRun=").append(this.dryRun).append(", ");
        }
        if (this.restrictedPackageName != null) {
            builder.append("restrictedPackageName=").append(this.restrictedPackageName).append(", ");
        }
        if (this.notification != null) {
            builder.append("notification: ").append(this.notification).append(", ");
        }
        if (!this.data.isEmpty()) {
            builder.append("data: {");
            for (Map.Entry<String, String> entry : this.data.entrySet()) {
                builder.append(entry.getKey()).append("=").append(entry.getValue()).append(",");
            }
            builder.delete(builder.length() - 1, builder.length());
            builder.append("}");
        }
        if (builder.charAt(builder.length() - 1) == ' ') {
            builder.delete(builder.length() - 2, builder.length());
        }
        builder.append(")");
        return builder.toString();
    }

    public static final class Builder {
        private final Map<String, String> data = new LinkedHashMap<String, String>();
        private String collapseKey;
        private Boolean delayWhileIdle;
        private Integer timeToLive;
        private Boolean dryRun;
        private String restrictedPackageName;
        private String priority;
        private Notification notification;

        public Builder collapseKey(String value) {
            this.collapseKey = value;
            return this;
        }

        public Builder delayWhileIdle(boolean value) {
            this.delayWhileIdle = value;
            return this;
        }

        public Builder timeToLive(int value) {
            this.timeToLive = value;
            return this;
        }

        public Builder addData(String key, String value) {
            this.data.put(key, value);
            return this;
        }

        public Builder dryRun(boolean value) {
            this.dryRun = value;
            return this;
        }

        public Builder restrictedPackageName(String value) {
            this.restrictedPackageName = value;
            return this;
        }

        public Builder priority(Priority value) {
            switch (value) {
                case NORMAL: {
                    this.priority = "normal";
                    break;
                }
                case HIGH: {
                    this.priority = "high";
                }
            }
            return this;
        }

        public Builder notification(Notification value) {
            this.notification = value;
            return this;
        }

        public Message build() {
            return new Message(this);
        }
    }

    public static enum Priority {
        NORMAL,
        HIGH;

    }
}

