/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gcm.ccs.server;

import com.google.android.gcm.ccs.server.XMPPGCMConnection;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.XMPPConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingConnectionListener
implements ConnectionListener {
    private static final Logger log = LoggerFactory.getLogger(LoggingConnectionListener.class);
    private XMPPGCMConnection connection;

    public LoggingConnectionListener(XMPPGCMConnection connection) {
        this.connection = connection;
    }

    public void connected(XMPPConnection xmppConnection) {
        log.info("Connected.");
    }

    public void reconnectionSuccessful() {
        if (this.connection.isDrainning()) {
            this.connection.setDrainning(false);
        }
        log.info("{} Reconnect SuccesFul", (Object)(this.connection.isDrainning() ? "Drainning Connection" : "Conenction"));
    }

    public void reconnectionFailed(Exception e) {
        log.info("Reconnection failed.. ", (Throwable)e);
    }

    public void reconnectingIn(int seconds) {
        log.info("Reconnecting in {} secs", (Object)seconds);
    }

    public void connectionClosedOnError(Exception e) {
        log.info("Connection closed on error.");
    }

    public void connectionClosed() {
        log.info("Connection {} closed.", (Object)(this.connection.isDrainning() ? "Drainning" : ""));
    }

    public void authenticated(XMPPConnection arg0, boolean arg1) {
        log.info("Connection authenticated.");
    }
}

