/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gcm.ccs.server;

import com.google.android.gcm.ccs.server.GcmPacketExtension;
import com.google.android.gcm.ccs.server.XMPPGCMConnection;
import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.service.MqProducer;
import com.humuson.tms.batch.service.PushInfoService;
import com.humuson.tms.batch.service.PushResultService;
import com.humuson.tms.common.model.CcsMessageId;
import com.humuson.tms.common.util.PushCcsMessageIdUtil;
import com.humuson.tms.constrants.CommonType;
import com.humuson.tms.mq.model.MgsPush;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CcsStanzaListener
implements StanzaListener {
    private static final Logger log = LoggerFactory.getLogger(CcsStanzaListener.class);
    XMPPGCMConnection connection;
    private MqProducer mqCampResProducer;
    private MqProducer mqAutoResProducer;
    PushInfoService<App, PushMessage> pushInfoServiceImpl;
    PushResultService pushResultSeviceImpl;
    private boolean upstreamUseFlag;
    private static final String MESSAGE_TYPE_UPSTREAM = "upstream";
    private static final String MESSAGE_TYPE_RECEIPT = "receipt";

    public CcsStanzaListener(XMPPGCMConnection connection, MqProducer mqCampResProducer, MqProducer mqAutoResProducer, PushInfoService<App, PushMessage> pushInfoServiceImpl, PushResultService pushResultSeviceImpl, boolean upstreamUseFlag) {
        this.connection = connection;
        this.mqCampResProducer = mqCampResProducer;
        this.mqAutoResProducer = mqAutoResProducer;
        this.pushInfoServiceImpl = pushInfoServiceImpl;
        this.pushResultSeviceImpl = pushResultSeviceImpl;
        this.upstreamUseFlag = upstreamUseFlag;
    }

    public void processPacket(Stanza packet) throws SmackException.NotConnectedException {
        log.debug("[CcsStanzaListener] Received: " + packet.toXML());
        Message incomingMessage = (Message)packet;
        GcmPacketExtension gcmPacket = (GcmPacketExtension)incomingMessage.getExtension("google:mobile:data");
        String json = gcmPacket.getJson();
        try {
            Map jsonObject = (Map)JSONValue.parseWithException((String)json);
            Object messageType = jsonObject.get("message_type");
            if (messageType == null) {
                if (this.upstreamUseFlag) {
                    this.handleUpstream(jsonObject, MESSAGE_TYPE_UPSTREAM);
                }
                String messageId = (String)jsonObject.get("message_id");
                String from = (String)jsonObject.get("from");
                String ack = CcsStanzaListener.createJsonAck(from, messageId);
                this.send(ack);
            } else if ("ack".equals(messageType.toString())) {
                this.handleAckReceipt(jsonObject);
            } else if ("nack".equals(messageType.toString())) {
                this.handleNackReceipt(jsonObject);
            } else if ("control".equals(messageType.toString())) {
                this.handleControlMessage(jsonObject);
            } else if (!MESSAGE_TYPE_RECEIPT.equals(messageType.toString())) {
                log.warn("Unrecognized message type {}", (Object)messageType.toString());
            }
        }
        catch (ParseException e) {
            log.error("Error parsing JSON {} / {}", (Object)json, (Object)e);
        }
        catch (Exception e) {
            log.error("Failed to process packet {}", (Throwable)e);
        }
    }

    public boolean sendDownstreamMessage(String jsonRequest) throws SmackException.NotConnectedException {
        if (!this.connection.isDrainning()) {
            this.send(jsonRequest);
            return true;
        }
        log.debug("Dropping downstream message since the connection is draining");
        return false;
    }

    public String nextMessageId() {
        return "m-" + UUID.randomUUID().toString();
    }

    protected void send(String jsonRequest) throws SmackException.NotConnectedException {
        Stanza request = new GcmPacketExtension(jsonRequest).toPacket();
        this.connection.sendStanza(request);
    }

    protected void handleUpstreamMessage(Map<String, Object> jsonObject) {
        String category = (String)jsonObject.get("category");
        String from = (String)jsonObject.get("from");
        log.debug("[handleUpstreamMessage] category: {} / from: {}", (Object)category, (Object)from);
        Map payload = (Map)jsonObject.get("data");
        for (String key : payload.keySet()) {
            log.debug(String.format("\ud0a4 : %s, \uac12 : %s", key, payload.get(key)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAckReceipt(Map<String, Object> jsonObject) {
        MgsPush.Response.Builder responseBuilder = null;
        MgsPush.Response.ResponsePayload.Builder responsePayloadBuilder = null;
        String messageId = (String)jsonObject.get("message_id");
        String from = (String)jsonObject.get("from");
        String[] splitMsgId = messageId.split(":");
        CcsMessageId msg = PushCcsMessageIdUtil.parseCcsMessageId((String)messageId);
        if (CommonType.TEST.equals((Object)msg.getCommonSendType()) && msg.isMqSending()) {
            return;
        }
        log.debug("recieveMsg {} ", jsonObject);
        try {
            if (msg.isMqSending()) {
                responseBuilder = MgsPush.Response.newBuilder();
                responsePayloadBuilder = MgsPush.Response.ResponsePayload.newBuilder();
                responsePayloadBuilder.clear();
                responseBuilder.clear();
                responseBuilder.setAppKey(this.pushInfoServiceImpl.selectAndroidAppKeyByAppGrpId(msg.getAppGrpId())).setPushChnType(MgsPush.PushChnType.GCM).setResultCode(MgsPush.Response.ResultCode.SUCCESS);
                responsePayloadBuilder.setId(msg.getId()).setReturnCode(MgsPush.Response.ReturnCode.SUCCESSFUL).setServerId(msg.getServerId());
                responseBuilder.addResPayload(responsePayloadBuilder.build());
                if (CommonType.AUTO.equals((Object)msg.getCommonSendType())) {
                    this.mqAutoResProducer.send(responseBuilder.build());
                    log.debug("handle Ack Auto Response que insert que name : {}", (Object)this.mqAutoResProducer.getDefaultDestination());
                } else if (CommonType.CAMP.equals((Object)msg.getCommonSendType())) {
                    this.mqCampResProducer.send(responseBuilder.build());
                    log.debug("handle Ack Camp Response que insert que name : {}", (Object)this.mqCampResProducer.getDefaultDestination());
                }
                this.pushResultSeviceImpl.deleteMqResend(msg.getReqUid());
            } else {
                this.pushResultSeviceImpl.deleteInsertPushResult(msg, "1000");
                log.debug("handle Ack insert que_log");
            }
        }
        catch (Exception e) {
            log.error("handleAckReceipt() error ", (Throwable)e);
            if (msg.isMqSending()) {
                log.error("Re Attempt Response send to MQ");
                if (CommonType.AUTO.equals((Object)msg.getCommonSendType())) {
                    this.mqAutoResProducer.send(responseBuilder.build());
                } else if (CommonType.CAMP.equals((Object)msg.getCommonSendType())) {
                    this.mqCampResProducer.send(responseBuilder.build());
                }
            } else {
                log.error("GCM CCS Response processing Error(deleteInsertPushResult) / pushId :{} / error : {}", (Object)msg.getPushId(), (Object)e);
            }
        }
        finally {
            responseBuilder = null;
            responsePayloadBuilder = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNackReceipt(Map<String, Object> jsonObject) {
        MgsPush.Response.Builder responseBuilder = null;
        MgsPush.Response.ResponsePayload.Builder responsePayloadBuilder = null;
        String messageId = (String)jsonObject.get("message_id");
        CcsMessageId msg = PushCcsMessageIdUtil.parseCcsMessageId((String)messageId);
        if (CommonType.TEST.equals((Object)msg.getCommonSendType()) && msg.isMqSending()) {
            return;
        }
        log.debug("recieveMsg {} ", jsonObject);
        String from = (String)jsonObject.get("from");
        String error = (String)jsonObject.get("error");
        String resultCd = null;
        resultCd = error.equals("BAD_ACK") ? "BAD_ACK" : (error.equals("BAD_REGISTRATION") ? "2004" : (error.equals("CONNECTION_DRAINING") ? "2009" : (error.equals("DEVICE_UNREGISTERED") ? "2006" : (error.equals("INTERNAL_SERVER_ERROR") ? "2009" : (error.equals("INVALID_JSON") ? "INVALID_JSON" : (error.equals("DEVICE_MESSAGE_RATE_EXCEEDED") ? "2002" : (error.equals("SERVICE_UNAVAILABLE") ? "2001" : "2009")))))));
        try {
            if (msg.isMqSending()) {
                responseBuilder = MgsPush.Response.newBuilder();
                responsePayloadBuilder = MgsPush.Response.ResponsePayload.newBuilder();
                responsePayloadBuilder.clear();
                responseBuilder.clear();
                responseBuilder.setAppKey(this.pushInfoServiceImpl.selectAndroidAppKeyByAppGrpId(msg.getAppGrpId())).setPushChnType(MgsPush.PushChnType.GCM).setResultCode(MgsPush.Response.ResultCode.SUCCESS);
                responsePayloadBuilder.setId(msg.getId()).setReturnCode(MgsPush.Response.ReturnCode.valueOf((int)Integer.parseInt(resultCd))).setServerId(msg.getServerId());
                responseBuilder.addResPayload(responsePayloadBuilder.build());
                if (CommonType.AUTO.equals((Object)msg.getCommonSendType())) {
                    this.mqAutoResProducer.send(responseBuilder.build());
                    log.debug("handle NACK {} Auto Response que insert que name : {}", (Object)resultCd, (Object)this.mqCampResProducer.getDefaultDestination());
                } else if (CommonType.CAMP.equals((Object)msg.getCommonSendType())) {
                    this.mqCampResProducer.send(responseBuilder.build());
                    log.debug("handle NACK {} Camp Response que insert que name : {}", (Object)resultCd, (Object)this.mqCampResProducer.getDefaultDestination());
                }
                this.pushResultSeviceImpl.deleteMqResend(msg.getReqUid());
            } else {
                this.pushResultSeviceImpl.deleteInsertPushResult(msg, resultCd);
                log.debug("handle NACK Response deleteInsertPushResult");
            }
        }
        catch (Exception e) {
            log.error("handleNackReceipt()-{} error : {}", (Object)messageId, (Object)e);
            if (msg.isMqSending()) {
                log.error("Re Attempt Response send to MQ");
                if (CommonType.AUTO.equals((Object)msg.getCommonSendType())) {
                    this.mqAutoResProducer.send(responseBuilder.build());
                } else if (CommonType.CAMP.equals((Object)msg.getCommonSendType())) {
                    this.mqCampResProducer.send(responseBuilder.build());
                }
            } else {
                log.error("GCM CCS Response processing Error(deleteInsertPushResult) / pushId :{} / error : {}", (Object)msg.getPushId(), (Object)e);
            }
        }
        finally {
            responseBuilder = null;
            responsePayloadBuilder = null;
        }
    }

    protected void handleControlMessage(Map<String, Object> jsonObject) {
        log.debug("handleControlMessage(): {}", jsonObject);
        String controlType = (String)jsonObject.get("control_type");
        if ("CONNECTION_DRAINING".equals(controlType)) {
            this.connection.setDrainning(true);
            log.info("CONNECTION_DRAINING!!!!!!!!!!!!!");
        } else {
            log.info("Unrecognized control type: {}. This could happen if new features are added to the CCS protocol.", (Object)controlType);
        }
    }

    public static String createJsonMessage(String to, String messageId, Map<String, String> payload, String collapseKey, Long timeToLive, Boolean delayWhileIdle) {
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("to", to);
        if (collapseKey != null) {
            message.put("collapse_key", collapseKey);
        }
        if (timeToLive != null) {
            message.put("time_to_live", timeToLive);
        }
        if (delayWhileIdle != null && delayWhileIdle.booleanValue()) {
            message.put("delay_while_idle", true);
        }
        message.put("message_id", messageId);
        message.put("data", payload);
        return JSONValue.toJSONString(message);
    }

    protected static String createJsonAck(String to, String messageId) {
        HashMap<String, String> message = new HashMap<String, String>();
        message.put("message_type", "ack");
        message.put("to", to);
        message.put("message_id", messageId);
        return JSONValue.toJSONString(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleUpstream(Map<String, Object> jsonObject, String mType) {
        MgsPush.Response.Builder responseBuilder = null;
        MgsPush.Response.ResponsePayload.Builder responsePayloadBuilder = null;
        String messageId = (String)jsonObject.get("message_id");
        log.debug("handleUpstream: {}", (Object)messageId);
        CcsMessageId msg = null;
        try {
            msg = CcsStanzaListener.parseUpstreamMessageId(messageId, mType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (msg != null) {
            Map payload = (Map)jsonObject.get("data");
            String resDate = (String)payload.get("res_date");
            if (resDate == null) {
                resDate = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            }
            if (CommonType.TEST.equals((Object)msg.getCommonSendType()) && msg.isMqSending()) {
                log.debug("this upsteam is TEST {}", (Object)messageId);
                return;
            }
            try {
                if (msg.isMqSending()) {
                    responseBuilder = MgsPush.Response.newBuilder();
                    responsePayloadBuilder = MgsPush.Response.ResponsePayload.newBuilder();
                    responsePayloadBuilder.clear();
                    responseBuilder.clear();
                    responseBuilder.setAppKey(this.pushInfoServiceImpl.selectAndroidAppKeyByAppGrpId(msg.getAppGrpId())).setPushChnType(MgsPush.PushChnType.GCM).setResultCode(MgsPush.Response.ResultCode.SUCCESS);
                    responsePayloadBuilder.setId(msg.getId()).setReturnCode(MgsPush.Response.ReturnCode.XMPP_DELIVER).setServerId(msg.getServerId());
                    responseBuilder.addResPayload(responsePayloadBuilder.build());
                    if (CommonType.AUTO.equals((Object)msg.getCommonSendType())) {
                        this.mqAutoResProducer.send(responseBuilder.build());
                        log.debug("handle {} Auto Response que insert que name : {}", (Object)mType, (Object)this.mqAutoResProducer.getDefaultDestination());
                    } else if (CommonType.CAMP.equals((Object)msg.getCommonSendType())) {
                        this.mqCampResProducer.send(responseBuilder.build());
                        log.debug("handle {} Camp Response que insert que name : {}", (Object)mType, (Object)this.mqCampResProducer.getDefaultDestination());
                    }
                } else {
                    this.pushResultSeviceImpl.insertPushDeliver(msg, "5001", resDate);
                    log.debug("handle {} insert push_que_log", (Object)mType);
                }
            }
            catch (Exception e) {
                log.error("handleAckReceipt() error ", (Throwable)e);
                if (msg.isMqSending()) {
                    log.error("Re Attempt Response send to MQ");
                    if (CommonType.AUTO.equals((Object)msg.getCommonSendType())) {
                        this.mqAutoResProducer.send(responseBuilder.build());
                    } else if (CommonType.CAMP.equals((Object)msg.getCommonSendType())) {
                        this.mqCampResProducer.send(responseBuilder.build());
                    }
                } else {
                    log.error("GCM CCS Response processing Error(deleteInsertPushResult) / pushId :{} / error : {}", (Object)msg.getPushId(), (Object)e);
                }
            }
            finally {
                responseBuilder = null;
                responsePayloadBuilder = null;
            }
        }
    }

    public static CcsMessageId parseUpstreamMessageId(String messageId, String messageType) {
        String[] splitOriMsgId = null;
        if (MESSAGE_TYPE_RECEIPT.equals(messageType)) {
            splitOriMsgId = messageId.split("dr2:");
        } else if (MESSAGE_TYPE_UPSTREAM.equals(messageType)) {
            splitOriMsgId = messageId.split("dr:");
        }
        if (splitOriMsgId != null) {
            messageId = splitOriMsgId[splitOriMsgId.length - 1];
        }
        log.debug("{} messageId : {}", (Object)messageType, (Object)messageId);
        return PushCcsMessageIdUtil.parseCcsMessageId((String)messageId);
    }
}

