/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gcm.ccs.server;

import com.google.android.gcm.ccs.server.CcsStanzaFilter;
import com.google.android.gcm.ccs.server.CcsStanzaListener;
import com.google.android.gcm.ccs.server.GcmPacketExtension;
import com.google.android.gcm.ccs.server.LoggingConnectionListener;
import com.google.android.gcm.ccs.server.XMPPGCMConnection;
import com.humuson.tms.batch.domain.App;
import com.humuson.tms.batch.domain.PushMessage;
import com.humuson.tms.batch.service.MqProducer;
import com.humuson.tms.batch.service.PushInfoService;
import com.humuson.tms.batch.service.PushResultService;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLSocketFactory;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ReconnectionManager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.DefaultExtensionElement;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class CcsConnectionManager {
    private static final Logger log = LoggerFactory.getLogger(CcsConnectionManager.class);
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    PushResultService pushResultSeviceImpl;
    @Value(value="#{config['xmpp.connection.size']}")
    private int maxConnection;
    @Value(value="#{config['send.gcm.type']}")
    protected String gcmType;
    @Value(value="#{config['xmpp.upstream.use.flag']}")
    private boolean upstreamUseFlag;
    private String selectAdroidAppInfo;
    private ConcurrentHashMap<String, List<XMPPGCMConnection>> connectionStorage = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Integer> storageIdxMap = new ConcurrentHashMap();
    @Autowired
    private PushInfoService<App, PushMessage> pushInfoServiceImpl;
    @Autowired
    @Qualifier(value="mqCampResProducer")
    private MqProducer mqCampResProducer;
    @Autowired
    @Qualifier(value="mqAutoResProducer")
    private MqProducer mqAutoResProducer;

    public CcsConnectionManager() {
        ReconnectionManager.setEnabledPerDefault((boolean)true);
        ProviderManager.addExtensionProvider((String)"gcm", (String)"google:mobile:data", (Object)new ExtensionElementProvider<ExtensionElement>(){

            public DefaultExtensionElement parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException {
                String json = parser.nextText();
                return new GcmPacketExtension(json);
            }
        });
    }

    public void init() {
        if (this.gcmType.equalsIgnoreCase("xmpp")) {
            List appInfoList = this.jdbcTemplate.query(this.selectAdroidAppInfo, (RowMapper)new RowMapper<App>(){

                public App mapRow(ResultSet rs, int rowNum) throws SQLException {
                    App app = new App();
                    app.setGcmProjectNum(rs.getLong("GCM_PROJECT_NUM"));
                    app.setGcmApiKey(rs.getString("GCM_API_KEY1"));
                    return app;
                }
            });
            for (App appInfo : appInfoList) {
                long senderId = appInfo.getGcmProjectNum();
                String apiKey = appInfo.getGcmApiKey();
                if (apiKey.length() > 20) {
                    if (this.getConnection(senderId, apiKey) == null) {
                        log.error("init connect() fail!  senderId : {}, apiKey : {}", (Object)senderId, (Object)apiKey);
                        continue;
                    }
                    log.info("init connect() senderId : {}, apiKey : {}", (Object)senderId, (Object)apiKey);
                    continue;
                }
                log.error("init not try connecting!  senderId : {}, apiKey : {}", (Object)senderId, (Object)apiKey);
            }
        }
    }

    public synchronized XMPPGCMConnection getConnection(long senderId, String apiKey) {
        int indicator = 0;
        if (this.storageIdxMap.containsKey(apiKey)) {
            indicator = this.storageIdxMap.get(apiKey);
            this.storageIdxMap.put(apiKey, (indicator + 1) % this.maxConnection);
            log.debug("getConnection indicator:{} senderId:{} apiKey:{} ", new Object[]{indicator, senderId, apiKey});
        }
        if (this.connectionStorage.containsKey(apiKey)) {
            if (this.connectionStorage.get(apiKey).get(indicator).isConnected() && !this.connectionStorage.get(apiKey).get(indicator).isDrainning()) {
                return this.connectionStorage.get(apiKey).get(indicator);
            }
            try {
                this.connect(senderId, apiKey);
                log.debug("Reconnect and getConncetion()! indicator: {} senderId: {} apiKey: {}", new Object[]{indicator, senderId, apiKey});
                return this.connectionStorage.get(apiKey).get(indicator);
            }
            catch (Exception e) {
                log.error("Retry getConncetion() error! indicator: {} senderId: {} apiKey: {}, Error : {}", new Object[]{indicator, senderId, apiKey, e});
                return null;
            }
        }
        try {
            this.connect(senderId, apiKey);
            return this.connectionStorage.get(apiKey).get(indicator);
        }
        catch (Exception e) {
            log.error("getConncetion() error! indicator: {} senderId: {} apiKey: {}, Error : {}", new Object[]{indicator, senderId, apiKey, e});
            return null;
        }
    }

    public synchronized void connect(long senderId, String apiKey) throws XMPPException, IOException, SmackException {
        ArrayList<XMPPGCMConnection> connList = new ArrayList<XMPPGCMConnection>();
        for (int i = 0; i < this.maxConnection; ++i) {
            XMPPTCPConnectionConfiguration config = ((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setServiceName("gcm.googleapis.com")).setHost("gcm.googleapis.com")).setCompressionEnabled(false).setPort(5235)).setConnectTimeout(30000).setSecurityMode(ConnectionConfiguration.SecurityMode.disabled)).setSendPresence(false)).setSocketFactory(SSLSocketFactory.getDefault())).build();
            XMPPGCMConnection connection = new XMPPGCMConnection(config);
            connection.setApiKey(apiKey);
            connection.setProjectNumber(senderId);
            ReconnectionManager.getInstanceFor((AbstractXMPPConnection)connection).enableAutomaticReconnection();
            connection.connect();
            connection.addConnectionListener(new LoggingConnectionListener(connection));
            connection.addSyncStanzaListener(new CcsStanzaListener(connection, this.mqCampResProducer, this.mqAutoResProducer, this.pushInfoServiceImpl, this.pushResultSeviceImpl, this.upstreamUseFlag), new CcsStanzaFilter());
            connection.login(senderId + "@gcm.googleapis.com", apiKey);
            connList.add(connection);
        }
        this.connectionStorage.put(apiKey, connList);
        this.storageIdxMap.put(apiKey, 0);
    }

    public void setSelectAdroidAppInfo(String selectAdroidAppInfo) {
        this.selectAdroidAppInfo = selectAdroidAppInfo;
    }
}

