/*
 * Decompiled with CFR 0.152.
 */
package com.apple.ios.apns;

import com.humuson.tms.batch.domain.App;
import com.humuson.tms.common.security.HumusonDecryptor;
import com.humuson.tms.common.security.SSLChecker;
import com.humuson.tms.common.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javapns.notification.AppleNotificationServer;
import javapns.notification.AppleNotificationServerBasicImpl;
import javapns.notification.PushNotificationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class ApnsConnectionManager {
    private static final Logger log = LoggerFactory.getLogger(ApnsConnectionManager.class);
    private String selectIosAppInfo;
    @Value(value="#{config['tms.db.enc.key']}")
    protected String encKey;
    @Value(value="#{config['tms.apns.production.cn']}")
    protected String productionCN;
    @Value(value="#{config['tms.apns.development.cn']}")
    protected String developmentCN;
    @Value(value="#{config['ios.cert.path']}")
    protected String iosCertPath;
    @Autowired
    JdbcTemplate jdbcTemplate;
    ConcurrentHashMap<String, PushNotificationManager> pushManagerConcurrentMap = new ConcurrentHashMap();

    public void init() {
        List appInfoList = this.jdbcTemplate.query(this.selectIosAppInfo, (RowMapper)new RowMapper<App>(){

            public App mapRow(ResultSet rs, int rowNum) throws SQLException {
                App app = new App();
                app.putAppKey("I", rs.getString("APP_KEY"));
                app.setApnsPushCert(rs.getString("PUSH_CERT"));
                app.setApnsPushPwd(rs.getString("ENC_2_PA"));
                return app;
            }
        });
        for (App app : appInfoList) {
            String apnsCert = this.iosCertPath.concat(File.separator).concat(app.getApnsPushCert().toString());
            String apnsPwd = app.getApnsPushPwd();
            String appKey = app.getAppKey("I");
            if (apnsCert != null && apnsPwd != null) {
                if (FileUtil.isValidFile((String)apnsCert)) {
                    try {
                        String decryptApnsPwd = HumusonDecryptor.decrypt((String)apnsPwd, (String)this.encKey);
                        PushNotificationManager pushManager = this.openApnsConnection(apnsCert, decryptApnsPwd, SSLChecker.isProduction((InputStream)new FileInputStream(apnsCert), (String)decryptApnsPwd, (String)this.productionCN, (String)this.developmentCN, (boolean)false));
                        if (pushManager != null) {
                            this.pushManagerConcurrentMap.put(appKey, pushManager);
                            continue;
                        }
                        log.error("apns manager put error : pushManager is null [appInfo:{}, encKey:{}]", (Object)app.toString(), (Object)this.encKey);
                    }
                    catch (Exception e) {
                        log.error("apns init exception [appInfo:{}, encKey:{}]", new Object[]{app.toString(), this.encKey, e});
                    }
                    continue;
                }
                log.error("APNS Cert File {} is not valid ", (Object)apnsCert);
                continue;
            }
            log.error("APNS Cert is Null or ApnsPwd is Null {}", (Object)app.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PushNotificationManager openApnsConnection(String apnsCertPath, String password, boolean isReal) {
        PushNotificationManager pushManager = null;
        try {
            AppleNotificationServerBasicImpl server = new AppleNotificationServerBasicImpl((Object)apnsCertPath, password, isReal);
            pushManager = new PushNotificationManager();
            pushManager.initializeConnection((AppleNotificationServer)server);
        }
        catch (Exception e) {
            log.error("error : {}", (Throwable)e);
            try {
                if (pushManager != null) {
                    pushManager.stopConnection();
                }
            }
            catch (Exception e2) {
                log.error("stop connection error", (Throwable)e2);
            }
            finally {
                pushManager = null;
            }
        }
        return pushManager;
    }

    public PushNotificationManager getPushNotificationManager(String appKey, String apnsCertPath, String password) throws Exception {
        PushNotificationManager pushManager = this.pushManagerConcurrentMap.get(appKey);
        if (pushManager == null) {
            pushManager = this.openApnsConnection(apnsCertPath, password, SSLChecker.isProduction((InputStream)new FileInputStream(apnsCertPath), (String)password, (String)this.productionCN, (String)this.developmentCN, (boolean)false));
            if (pushManager != null) {
                this.pushManagerConcurrentMap.put(appKey, pushManager);
            } else {
                throw new Exception("Push Manager Create Fail");
            }
        }
        return pushManager;
    }

    public void setSelectIosAppInfo(String selectIosAppInfo) {
        this.selectIosAppInfo = selectIosAppInfo;
    }
}

