package com.humuson.tms.batch.writer;

import java.util.List;

import org.apache.poi.ss.formula.functions.T;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.jms.JmsItemWriter;

import com.humuson.tms.mq.model.MgsPush;
import com.humuson.tms.mq.model.MgsPush.Request;
import com.humuson.tms.mq.model.MgsPush.Response;
import com.humuson.tms.mq.model.MgsPush.Response.ResponsePayload;

import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class TestWriter extends JmsItemWriter<MgsPush.Request> implements StepExecutionListener {@Override
	public void beforeStep(StepExecution stepExecution) {
		// TODO Auto-generated method stub
		
	}

	@Override
		public void write(List<? extends MgsPush.Request> items) throws Exception {
			for(Request req : items){
				for(MgsPush.PushPayload payload : req.getPayloadList()){
					log.info("apns msg id : {}" , payload.getApnsMessage().getMsgId());
					log.info("gcm msg id : {}", payload.getGcmMessage().getMsgId());
				}
			}
		}
	
	@Override
	public ExitStatus afterStep(StepExecution stepExecution) {
		// TODO Auto-generated method stub
		return ExitStatus.COMPLETED;
	}
			

	
	
}
