package com.humuson.tms.batch.writer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;

import com.humuson.tms.batch.domain.ChannelSendType;
import com.humuson.tms.batch.domain.SmsResultLog;
import com.humuson.tms.constrants.ChannelType;

import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class SmsResultWriter extends AbstractResultWriter<SmsResultLog> {
	
	@Override
	public void execute(ChannelSendType channelSendType, String postId,
			String rtnType, List<SmsResultLog> logList) {
		log.info("execute [channelSendType:{}, postId:{}, size:{}", 
				channelSendType, postId,  logList.size());
		
		SqlParameterSource[] params = SqlParameterSourceUtils.createBatch(logList.toArray());
		Map<String, Map<String, Object>> scheduleStatMap = new HashMap<String, Map<String, Object>>();
		
		String updateSendList = null;
		String updateScheduleStat = null;
		String listTable = logList.get(0).getListTable();
		
		Map<String, Object> map = null;
		for (SmsResultLog resultLog : logList) {
			map = scheduleStatMap.get(resultLog.getMonthDay() + resultLog.getHour());
			
			if (map == null) {
				map = new HashMap<String, Object>();
				if (channelSendType.equals(ChannelSendType.AUTO)) {
					map.put("workday", postId.split("_")[0]);
					map.put("seqnNo", postId.split("_")[0]);
				} else {
					map.put("postId", postId);
				}
				map.put("failCnt", 0);
				map.put("pushedCnt", 0);
				map.put("monthDay", resultLog.getMonthDay());
				map.put("hour", resultLog.getHour());
				
			}
			map.put("failCnt", (Integer)map.get("failCnt") + resultLog.getFailCnt());
			map.put("pushedCnt", (Integer)map.get("pushedCnt") + resultLog.getPushedCnt());
			
			scheduleStatMap.put(resultLog.getMonthDay() + resultLog.getHour(), map);
		}
			
		if (channelSendType.equals(ChannelSendType.AUTO)) {
			updateSendList = updateAutoSendList.replace("@LIST_TABLE@", listTable);
			updateScheduleStat = updateAutoScheduleStat;
		} else if (channelSendType.equals(ChannelSendType.CAMP)) {
			updateSendList = updateCampSendList.replace("@LIST_TABLE@", listTable);;
			updateScheduleStat = updateCampScheduleStat;
		}
		
		Set<String> statKeys = scheduleStatMap.keySet();
		
		try {	
			log.info("update Send List [table:{}, count:{}]", listTable, params.length);
			updateResultServiceImpl.updateList(ChannelType.PUSH, 
					channelSendType, 
					rtnType, 
					updateSendList, 
					params);
			
			for (String key : statKeys) {
				log.info("update stat [SQL:{}, SendType:{}, RtnType:{}, {}]", updateScheduleStat, channelSendType.getCode(), rtnType, scheduleStatMap.get(key).toString());
				namedParameterJdbcTemplate.update(updateScheduleStat, scheduleStatMap.get(key));
			}
		} catch (Exception e) {
			int cnt;
			for (SmsResultLog resultLog : logList) {
				try {
					cnt = namedParameterJdbcTemplate.update(updateSendList, resultLog.toMap());
					if (cnt > 0) {
						namedParameterJdbcTemplate.update(updateScheduleStat, resultLog.toMap());
					}
				} catch (Exception e2) {
					log.error("update error [{}]", resultLog.toString());
				}
			}
		}
	}

	@Override
	protected void updateCheckFlag(List<? extends SmsResultLog> rawData) {
		long startTime = System.currentTimeMillis();
		SmsResultLog[] params = rawData.toArray(new SmsResultLog[rawData.size()]);
		try {
			updateResultServiceImpl.updateCheckFlag(updateCheckFlag, params);
		} catch (Exception e) {
			for (SmsResultLog param : params) {
				try {
					updateResultServiceImpl.updateCheckFlag(updateCheckFlag, param);
				} catch (Exception e2) {
					log.error("update error param:[{}]", param.toString(), e2);
				}
			}
		}
		
		log.info("update checkFlag [count:{}, elapseTime:{}]", rawData.size(), (System.currentTimeMillis() - startTime));
	}
}


