package com.humuson.tms.batch.writer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;

import com.humuson.tms.batch.domain.ChannelSendType;
import com.humuson.tms.batch.domain.PushResultLog;
import com.humuson.tms.constrants.ChannelType;

import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class PushResultWriter extends AbstractResultWriter<PushResultLog> {
	
	
	@Value("#{dbConfig['tms.jdbc.type']}")
	protected String dbType;
	
	/**
	 * 
	 */
	@Override
	public void execute(ChannelSendType channelSendType, String postId,
			String rtnType, List<PushResultLog> logList) {
		log.info("execute [channelSendType:{}, postId:{}, rtnType:{}, size:{}", 
				channelSendType, postId, rtnType, logList.size());
		
		Map<String, Map<String, Object>> scheduleStatMap = new HashMap<String, Map<String, Object>>();

		ArrayList<String> remainStatList = new ArrayList<String>();
		ArrayList<String> remainResponseStatList = new ArrayList<String>();
		
		List<PushResultLog> pkLogList = new ArrayList<PushResultLog>();
		
		boolean isSendListUpdateSuccess = false;
		boolean isPkSendListUpdateSuccess = false;
		boolean isResponseSendListUpdateSuccess = false;
		
		String updateSendList = null;
		String updateResponseList = null;
		String updateScheduleStat = null;
		String updateResponseStat = null;
		String updateClickLinkStat = null;
		String listTable = logList.get(0).getListTable();
		
		boolean isOracleDb = "ORACLE".equalsIgnoreCase(dbType);
//		boolean isRtnTypeSend = SEND.equals(rtnType);
		boolean isRowIdUpdate = false;
		if(!isOracleDb){
			//오라클 아니면
			pkLogList = logList;
		}else if(READ.equals(rtnType) || CLICK.equals(rtnType)){
			//읽음 또는 클릭 일 경우
			pkLogList = logList;
		}
		
		Iterator<PushResultLog> itr = logList.iterator();
		while(itr.hasNext()){
			PushResultLog resultLog = itr.next();
			Map<String, Object> map = scheduleStatMap.get(resultLog.getMonthDay() + resultLog.getHour());
			
			if (map == null) {
				map = new HashMap<String, Object>();
				if (channelSendType.equals(ChannelSendType.AUTO)) {
					map.put("workday", postId.split("_")[0]);
					map.put("seqNo", postId.split("_")[1]);
				} else {
					map.put("postId", postId);
				}
				map.put("failCnt", 0);
				map.put("pushedCnt", 0);
				map.put("clickCnt", 0);
				map.put("clickCntAndroid", 0);
				map.put("clickCntIos", 0);
				map.put("openCnt", 0);
				map.put("openCntAndroid", 0);
				map.put("openCntIos", 0);
				map.put("monthDay", resultLog.getMonthDay());
				map.put("hour", resultLog.getHour());
				
			}
			map.put("failCnt", (Integer)map.get("failCnt") + resultLog.getFailCnt());
			map.put("pushedCnt", (Integer)map.get("pushedCnt") + resultLog.getPushedCnt());
			map.put("clickCnt", (Integer)map.get("clickCnt") + resultLog.getClickCnt());
			map.put("clickCntAndroid", (Integer)map.get("clickCntAndroid") + resultLog.getClickCntAndroid());
			map.put("clickCntIos", (Integer)map.get("clickCntIos") + resultLog.getClickCntIos());
			map.put("openCnt", (Integer)map.get("openCnt") + resultLog.getOpenCnt());
			map.put("openCntAndroid", (Integer)map.get("openCntAndroid") + resultLog.getOpenCntAndroid());
			map.put("openCntIos", (Integer)map.get("openCntIos") + resultLog.getOpenCntIos());
			
			if( isOracleDb && (SEND.equals(rtnType) || DELIVER.equals(rtnType)) &&(resultLog.getRowId() == null || "".equals(resultLog.getRowId()))   ){
				// row id 기반 update 를 해야하는데도 불구하고 row id 가 없는 경우는 pk 기반 update 수행하기 위하여 pkLogList 에 add
				pkLogList.add(resultLog);
				itr.remove();
			}
			
			scheduleStatMap.put(resultLog.getMonthDay() + resultLog.getHour(), map);
		}
		/*
		 * sendlist / schd update query 생성부
		if (DELIVER.equals(rtnType)) {
			//upstream 정보 반영 시, send/read/click 과는 별개의 쿼리 사용. schdl table 도  update 하지 않는다.
			if (channelSendType.equals(ChannelSendType.AUTO)) {
				updateSendList = updateAutoSendListDeliver.replace("@LIST_TABLE@", listTable);
			} else if (channelSendType.equals(ChannelSendType.CAMP)) {
				updateSendList = updateCampSendListDeliver.replace("@LIST_TABLE@", listTable);
				updateSendList = updateSendList.replace("@PK_HINT@", listTable.replace("TMS", "PK"));
			}
		} else {
			//send/read/click 의 경우 해당 쿼리.
			if (channelSendType.equals(ChannelSendType.AUTO)) {
				updateSendList = updateAutoSendList.replace("@LIST_TABLE@", listTable);
				updateScheduleStat = updateAutoScheduleStat;
			} else if (channelSendType.equals(ChannelSendType.CAMP)) {
				updateSendList = updateCampSendList.replace("@LIST_TABLE@", listTable);
				updateSendList = updateSendList.replace("@PK_HINT@", listTable.replace("TMS", "PK"));
				updateScheduleStat = updateCampScheduleStat;
			}
		}
		*/
		updateSendList = makeListQuery(rtnType, channelSendType, listTable, isOracleDb);
		if (!DELIVER.equals(rtnType)) updateScheduleStat = makeSchdQuery(channelSendType);
		
		
		Set<String> statKeys = scheduleStatMap.keySet();
		remainStatList.addAll(statKeys);
		remainResponseStatList.addAll(statKeys);
	
		//row id 기반 업데이트
		SqlParameterSource[] params = null;
		if(isOracleDb && (SEND.equals(rtnType) || DELIVER.equals(rtnType)) ){
			params = SqlParameterSourceUtils.createBatch(logList.toArray());
		}
				
		//pk 기반 업데이트
		SqlParameterSource[] pkParams = SqlParameterSourceUtils.createBatch(pkLogList.toArray());
		
		try {	
			if (log.isDebugEnabled()) {
				log.info("update Send List [table:{}, count:{}, SQL: {}]", listTable, (params !=null ? params.length : 0) + (pkParams !=null ? pkParams.length : 0) , updateSendList);
			}
			if( !(params == null || (params !=null ? params.length : 0) < 1) ){
				isRowIdUpdate = true;
				updateResultServiceImpl.updateList(ChannelType.PUSH, 
					channelSendType, 
					rtnType, 
					updateSendList, 
					params);
			}
			isSendListUpdateSuccess = true;
			if( !(pkParams == null || pkParams.length < 1) ){
				updateResultServiceImpl.updateList(ChannelType.PUSH, 
						channelSendType, 
						rtnType, 
						updateSendList, 
						pkParams);
			}
			isPkSendListUpdateSuccess = true;
			
			log.info("update send list count :{}", (params !=null ? params.length : 0) + (pkParams !=null ? pkParams.length : 0));
			if(!DELIVER.equals(rtnType)) {
				//schd 통계 update 파트. upstream 일 경우는 미반영
				int cnt = 0;
				for (String key : statKeys) {
					if (log.isDebugEnabled()) {
						log.info("update stat [SQL:{}, SendType:{}, RtnType:{}, {}]", 
								updateScheduleStat, channelSendType.getCode(), rtnType, scheduleStatMap.get(key).toString());
					}
//					cnt += namedParameterJdbcTemplate.update(updateScheduleStat, scheduleStatMap.get(key));
					//Requries_new 를 통해 트랜잭션을 별도 생성 처리 하여 Stat을 업데이트
					cnt += updateResultServiceImpl.updateStat(updateScheduleStat, scheduleStatMap.get(key));
					remainStatList.remove(key);
				}
				log.info("update scheduleStat count:{}", cnt);
			}
			
		} catch (Exception e) {
			log.error("push que log update error / retry push que log update :{} ", e);
			log.error("push que log update error / remain stat list ( null is something wrong ) :{} ", remainStatList);
			int cnt;
			
			if(!isSendListUpdateSuccess && isOracleDb && (SEND.equals(rtnType) || DELIVER.equals(rtnType)) && isRowIdUpdate ){
				//oracle 이면서 send OR upstream
				for (PushResultLog resultLog : logList) {
					try {
						cnt = namedParameterJdbcTemplate.update(updateSendList, resultLog.toMap());
						if(cnt < 1 ){
							log.error("update is null error( uptCnt = 0 ) : [{}]", resultLog.toString());
							continue;
						}
					} catch (Exception e2) {
						log.error("update error [{}], msg:{}", resultLog.toString(), e2.getMessage());
					}
				}
			}
			
			if(!isPkSendListUpdateSuccess){
				for (PushResultLog resultLog : pkLogList) {
					try {
						cnt = namedParameterJdbcTemplate.update(updateSendList, resultLog.toMap());
						if(cnt < 1 ){
							log.error("update is null error( uptCnt = 0 ) : [{}]", resultLog.toString());
							continue;
						}
					} catch (Exception e2) {
						log.error("update error [{}], msg:{}", resultLog.toString(), e2.getMessage());
					}
				}
			}
			
			// 실패 stat 업데이트 처리. upstream 일 경우는 미반영
			if(!DELIVER.equals(rtnType)) {
				for(String key : scheduleStatMap.keySet()){
					try {
						// try 문에서 requires_new로 별도 트랜잭션을 생성하여 업데이트 하였으므로 중간에 실패시 중복 업데이트를 방지하기 위함
						if(remainStatList.contains(key)){
							updateResultServiceImpl.updateStat(updateScheduleStat, scheduleStatMap.get(key));
							log.info("reyty update stat success Key : [{}], Value: {} msg:{}", key,scheduleStatMap.get(key));
						}
					} catch (Exception e1) {
						log.error("reyty update stat error  FailKey : [{}], FailValue: {} msg:{}", key,scheduleStatMap.get(key), e1.getMessage());
					}
				}
			}
			
		}
		

		//READ, CLICK
		if (READ.equals(rtnType) || CLICK.equals(rtnType)) {
			if (READ.equals(rtnType)) {
				if (channelSendType.equals(ChannelSendType.AUTO)) {
					updateResponseList = updateAutoOpenList;
					updateResponseStat = updateAutoOpenStat;
				} else if (channelSendType.equals(ChannelSendType.CAMP)) {
					updateResponseList = updateCampOpenList;
					updateResponseStat = updateCampOpenStat;
				}
			} else if (CLICK.equals(rtnType)) {
				if (channelSendType.equals(ChannelSendType.AUTO)) {
					updateResponseList = updateAutoClickList;
					updateResponseStat = updateAutoClickStat;
					updateClickLinkStat = updateAutoClickLinkStat;
				} else if (channelSendType.equals(ChannelSendType.CAMP)) {
					updateResponseList = updateCampClickList;
					updateResponseStat = updateCampClickStat;
					updateClickLinkStat = updateCampClickLinkStat;
				}
			}
			
			log.info("update Response List [table:{}, count:{}]", READ.equals(rtnType) ?  "Open": "Click", pkParams.length);
			try {
				updateResultServiceImpl.updateList(ChannelType.PUSH, 
						channelSendType, 
						rtnType, 
						updateResponseList, 
						pkParams);
				
				isResponseSendListUpdateSuccess = true;

				for (String key : statKeys) {
					log.info("update stat [SendType:{}, RtnType:{}, {}]", channelSendType.getCode(), rtnType, scheduleStatMap.get(key).toString());
					updateResultServiceImpl.updateStat(updateResponseStat, scheduleStatMap.get(key));
					remainResponseStatList.remove(key);
				}
				
				if (updateClickLinkStat != null) {
					updateResultServiceImpl.updateResponseStat(updateClickLinkStat, pkParams);
				}
			} catch (Exception e) {
				log.error("update Response error : {} ", e);
				if(!isResponseSendListUpdateSuccess){
					for (PushResultLog resultLog : pkLogList ) {
						try {
							namedParameterJdbcTemplate.update(updateResponseList, new BeanPropertySqlParameterSource(resultLog));
						} catch (Exception e2) {
							log.error("reyty update Response error [{}]", resultLog.toString(), e2);
						}
					}
				}
				
				for(String key : scheduleStatMap.keySet()){
					try {
						if(remainResponseStatList.contains(key)){
							updateResultServiceImpl.updateStat(updateScheduleStat, scheduleStatMap.get(key));
							log.info("retry update response stat success Key : [{}],  msg:{}", key,scheduleStatMap.get(key));
						}
					} catch (Exception e1) {
						log.error("retry update response stat error  FailKey : [{}],  msg:{}", key,scheduleStatMap.get(key), e1.getMessage());
					}
				}
				
				if (updateClickLinkStat != null) {
					try{
						updateResultServiceImpl.updateResponseStat(updateClickLinkStat, params);
					}catch(Exception e2){
						log.error("retry updateClickLinkStat error msg:{}", e2.getMessage());
					}
				}
			}
		}
	}

	@Override
	protected void updateCheckFlag(final List<? extends PushResultLog> rawData) {
		long startTime = System.currentTimeMillis();
		PushResultLog[] params = rawData.toArray(new PushResultLog[rawData.size()]);
		try {
			updateResultServiceImpl.updateCheckFlag(updateCheckFlag, params);
		} catch (Exception e) {
			for (PushResultLog param : params) {
				try {
					updateResultServiceImpl.updateCheckFlag(updateCheckFlag, param);
				} catch (Exception e2) {
					log.error("update error param:[{}]", param.toString(), e2);
				}
			}
		}
		
		log.info("update checkFlag [count:{}, elapseTime:{}]", rawData.size(), (System.currentTimeMillis() - startTime));
	}
	
	private String makeListQuery(String rtnType, ChannelSendType channelSendType, String listTable, boolean isOracleDb) {
		String query = null;
		if (isOracleDb && SEND.equals(rtnType)) {
			//oracle + send 시 쿼리
			if (channelSendType.equals(ChannelSendType.AUTO)) {
				query = updateAutoSendListByRowId.replace("@LIST_TABLE@", listTable);
			} else if (channelSendType.equals(ChannelSendType.CAMP)) {
				query = updateCampSendListByRowId.replace("@LIST_TABLE@", listTable);
			}
		} else if (isOracleDb && DELIVER.equals(rtnType)) {
			//oracle + upstream 정보 반영 시, send/read/click 과는 별개의 쿼리 사용. schdl table 도  update 하지 않는다.
			if (channelSendType.equals(ChannelSendType.AUTO)) {
				query = updateAutoSendListDeliverByRowId.replace("@LIST_TABLE@", listTable);
			} else if (channelSendType.equals(ChannelSendType.CAMP)) {
				query = updateCampSendListDeliverByRowId.replace("@LIST_TABLE@", listTable);
			}
		} else {
			//read/click 또는 oracle 이 아닐 경우
			if (DELIVER.equals(rtnType)) {
				//upstream 정보 반영 시, send/read/click 과는 별개의 쿼리 사용. schdl table 도  update 하지 않는다.
				if (channelSendType.equals(ChannelSendType.AUTO)) {
					query = updateAutoSendListDeliver.replace("@LIST_TABLE@", listTable);
				} else if (channelSendType.equals(ChannelSendType.CAMP)) {
					query = updateCampSendListDeliver.replace("@LIST_TABLE@", listTable);
					query = query.replace("@PK_HINT@", listTable.replace("TMS", "PK"));
				}
			} else {
				//send/read/click 의 경우 해당 쿼리.
				if (channelSendType.equals(ChannelSendType.AUTO)) {
					query = updateAutoSendList.replace("@LIST_TABLE@", listTable);
				} else if (channelSendType.equals(ChannelSendType.CAMP)) {
					query = updateCampSendList.replace("@LIST_TABLE@", listTable);
					query = query.replace("@PK_HINT@", listTable.replace("TMS", "PK"));
				}
			}
		}
		return query;
	}
	private String makeSchdQuery(ChannelSendType channelSendType) {
		String query = null;
		if (channelSendType.equals(ChannelSendType.AUTO)) {
			query = updateAutoScheduleStat;
		} else if (channelSendType.equals(ChannelSendType.CAMP)) {
			query = updateCampScheduleStat;
		}
		return query;
	}
}


