package com.humuson.tms.batch.writer;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;

import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;

import com.humuson.tms.batch.domain.FatigueFilterSchedule;
import com.humuson.tms.batch.domain.FatigueInfo;
import com.humuson.tms.batch.domain.SiteFatigueSettingInfo;
import com.humuson.tms.batch.job.constrants.JobParamConstrants;
import com.humuson.tms.constrants.CommonType;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * Fatique 정보 update
 * @author kmc
 *
 */
@Slf4j
public class FatigueListWriter implements ItemWriter<FatigueInfo>, StepExecutionListener{
	
	private static final String UNDER_BAR = "_";
	
	String sendType;
	String siteId;
	String postId;
	String serverId;
	String channelType;
	
	@Setter private String selectSiteFatigueFilterCntSql;
	
	private String filteredSendListUpdateSql;
	@Setter
	private String filteredCampSendListUpdateSql;
	@Setter
	private String filteredAutoSendListUpdateSql;
	
	private String updateSchdlFilterCntSql;
	@Setter
	private String updateCampSchdlFilterCntSql;
	@Setter
	private String updateAutoSchdlFilterCntSql;
	
	@Autowired private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
	JdbcTemplate jdbcTemplate;
	
	public void write(List<? extends FatigueInfo> rawData) throws Exception {
		
		if (rawData.isEmpty()) {
			return;
		}
		
		SqlParameterSource[] params = SqlParameterSourceUtils.createBatch(rawData.toArray());
		
		//updateFatigueList( rawData, params ); TMS_FATIGUE_LIST 카운트 업데이트는 엔진에서 먼저하는 것으로 수정함.
		
		int filterCnt = rawData.size();
		
		if (CommonType.MASS.getCode().equals(sendType)) {
			filteredSendListUpdateSql = filteredCampSendListUpdateSql;
		} else {
			filteredSendListUpdateSql = filteredAutoSendListUpdateSql;
		}
		
		try {
			
			namedParameterJdbcTemplate.batchUpdate(filteredSendListUpdateSql, params);
			
		} catch (DataAccessException e) {
			
			log.error("updateFilteredUserErrorCode batch update error siteId : {}, postId : {}, channelType : {}", siteId, postId, channelType);
			
			log.error("updateFilteredUserErrorCode batch update error ", e);
			
			int size = rawData.size();
			SqlParameterSource param;
			for (int i = size -1; i >= 0 ; i--) {
				param = params[i];
				
				try {
					namedParameterJdbcTemplate.update(filteredSendListUpdateSql, param);
					
				} catch (Exception e2) {
					
					filterCnt--;
					
					FatigueInfo info = rawData.get(i);
					
					log.error("updateFilteredUserErrorCode duplicate skip siteId : {}, postId : {}, channelType : {}, memberId : {}",siteId,channelType,info.getMemberId(),info.getWorkday());
				}
			}
		}
		
		updateSchdlFilterCnt(filterCnt);
	}
	
	public void updateSchdlFilterCnt(int filterCnt) {
		
		FatigueFilterSchedule info = new FatigueFilterSchedule();
		info.setServerId(serverId);
		info.setFilterCnt(filterCnt);
		
		if (CommonType.MASS.getCode().equals(sendType)) {
			info.setPostId(postId);
			
			updateSchdlFilterCntSql = updateCampSchdlFilterCntSql;
		} else {
			String[] workdayAndSeqno = postId.split(UNDER_BAR);
			if (workdayAndSeqno.length < 2) {
				return ;
			}
			String workday = workdayAndSeqno[0];
			int seqno = Integer.parseInt(workdayAndSeqno[1]);
			
			info.setWorkday(workday);
			info.setSeqno(seqno);
			
			updateSchdlFilterCntSql = updateAutoSchdlFilterCntSql;
		}
		
		namedParameterJdbcTemplate.update(updateSchdlFilterCntSql, new BeanPropertySqlParameterSource(info));
	}
	
	/*
	public void updateFatigueList(List<? extends FatigueInfo> rawData, SqlParameterSource[] params) {
		
		try {
			
			namedParameterJdbcTemplate.batchUpdate(upsertFatigueInfoSql, params);
			
		} catch (DataAccessException e) {
			
			log.error("updateFatigueList batch update error siteId : {}, postId : {}, channelType : {}", siteId, postId, channelType);
			
			log.error("updateFatigueList batch update error ", e);
			
			int size = rawData.size();
			SqlParameterSource param;
			for (int i = size -1; i >= 0 ; i--) {
				param = params[i];
				
				try {
					namedParameterJdbcTemplate.update(upsertFatigueInfoSql, param);
					
				} catch (Exception e2) {
					FatigueInfo info = rawData.get(i);
					log.error("updateFatigueList duplicate skip siteId : {}, postId : {}, channelType : {}, memberId : {}",siteId,channelType,info.getMemberId(),info.getWorkday());
				}
			}
		}
	}*/
	
	/*public int filter(List<? extends FatigueInfo> rawData, SqlParameterSource[] params) {
		
		int filterCnt = 0;
		
		List<SqlParameterSource> updateRowParams = new LinkedList<SqlParameterSource>();
		
		if (CommonType.MASS.getCode().equals(sendType)) {
			filteredSendListUpdateSql = filteredCampSendListUpdateSql;
		} else {
			filteredSendListUpdateSql = filteredAutoSendListUpdateSql;
		}
		
		for ( int i=0, j=rawData.size(); i < j; i++ ) {
			
			FatigueInfo info = rawData.get(i);
			
			log.debug("FatigueInfo: {}", info);
			 
			*//**
			 * 필터step 전 단계에서 sent cnt 값은 이미 +1 되어 있다.  
			 *//*
			if ( info.getDaySentCnt() > fatigueSettingInfo.getDayLimit()
					|| info.getMonthSentCnt() > fatigueSettingInfo.getMonthLimit() ) {
				filterCnt++;
				updateRowParams.add(params[i]); //필터 대상자 memberId를 list에 담는다.
			}
		}

		if ( updateRowParams.size() == 0 ) {
			return 0;
		}
		
		try {
			
			namedParameterJdbcTemplate.batchUpdate(filteredSendListUpdateSql, ));
			
		} catch (DataAccessException e) {
			
			log.error("updateFilteredUserErrorCode batch update error siteId : {}, postId : {}, channelType : {}", siteId, postId, channelType);
			
			log.error("updateFilteredUserErrorCode batch update error ", e);
			
			int size = rawData.size();
			SqlParameterSource param;
			for (int i = size -1; i >= 0 ; i--) {
				param = params[i];
				
				try {
					namedParameterJdbcTemplate.update(filteredSendListUpdateSql, param);
					
				} catch (Exception e2) {
					
					filterCnt--;
					
					FatigueInfo info = rawData.get(i);
					
					log.error("updateFilteredUserErrorCode duplicate skip siteId : {}, postId : {}, channelType : {}, memberId : {}",siteId,channelType,info.getMemberId(),info.getWorkday());
				}
			}
		}
		
		return filterCnt;
	}*/

	@Override
	public void beforeStep(StepExecution stepExecution) {
		
		sendType = stepExecution.getJobParameters().getString(JobParamConstrants.SEND_TYPE);
		siteId				= stepExecution.getJobParameters().getString(JobParamConstrants.SITE_ID);
		postId				= stepExecution.getJobParameters().getString(JobParamConstrants.POST_ID);
		serverId			= stepExecution.getJobParameters().getString(JobParamConstrants.SERVER_ID);
		channelType			= stepExecution.getJobParameters().getString(JobParamConstrants.CHN_TYPE);
		
	}

	@Override
	public ExitStatus afterStep(StepExecution stepExecution) {
		return stepExecution.getExitStatus();
	}
	
}
