package com.humuson.tms.batch.writer;

import java.util.List;

import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;

import com.humuson.amc.client.model.response.Audience;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * 타겟팅 대상(FILE/ DB) 정보를 TMS_CAMP_SEND_LIST_XX로 입력을 담당
 * @author hyogun
 *
 */
@Slf4j
public class AmcApiTargetingWriter implements ItemWriter<Audience>, StepExecutionListener {
	
	@Autowired private JdbcTemplate jdbcTemplate;
	@Autowired private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
	
	@Setter private String insertAmcTargetUserList;
	
	private StepExecution stepExecution;
	
	@Override
	public void write(List<? extends Audience> rawData) throws Exception {
		
		SqlParameterSource[] params = SqlParameterSourceUtils.createBatch(rawData.toArray());
		long startTime = System.currentTimeMillis();
		try{
			namedParameterJdbcTemplate.batchUpdate(insertAmcTargetUserList, params);
		}catch (DuplicateKeyException e){
			log.error("AmcApiTargetingWriter batch insert Fail  =>  one2one insert error" );
			for(SqlParameterSource param : params){
				try{
					namedParameterJdbcTemplate.update(insertAmcTargetUserList, param);
				}catch (DuplicateKeyException e2){
//					log.error("one2one insert error custId : {} / error : {}" , param.getValue("custId"), e);
				}
			}
		}
		
		log.info("AmcApiTargetingWriter insert success - elapseTime : {}" , System.currentTimeMillis() - startTime );
	}

	@Override
	public void beforeStep(StepExecution stepExecution) {
		this.stepExecution = stepExecution;
		
	}

	@Override
	public ExitStatus afterStep(StepExecution stepExecution) {
		return stepExecution.getExitStatus();
	}
	
	public static void main(String[] args) {
		String a = "lBME72nnpBRKBnzm/oph9+5eo8opEDDZIat9OtjK4l4=";
		System.out.println(a.length());
	}
}
