package com.humuson.tms.batch.step.filter;

import org.springframework.beans.factory.annotation.Value;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import com.humuson.tms.common.model.target.TargetData;
import com.humuson.tms.common.security.HumusonDecryptor;
import com.humuson.tms.common.security.HumusonEncryptor;
import com.humuson.tms.common.util.StringUtils;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class ValidationSmsChannel implements Validator<TargetData> {
	
	@Setter private String sourceTargetEncryptYn;
	@Setter private String dbEncryptFlag;
	@Value("#{config['tms.db.enc.key']}") private String encKey;
	
	@Override
	public boolean checkValidation(TargetData t, boolean isStrict) {
		String phone = t.getMemberPhone();
		
		if ("Y".equals(sourceTargetEncryptYn)) {
			try {
				phone = HumusonDecryptor.decrypt(phone, encKey, false);
			} catch (Exception e) {
				phone = null;
				log.error("decrypt error", e);
			}
		}
		
		if (isStrict) {
			if (StringUtils.isSmsError(phone)) {
				return false;
			}
		}
		
		t.setTelCode(StringUtils.getTeleCom(phone));
		
		if ("Y".equals(dbEncryptFlag)) {
			t.setMemberPhone(HumusonEncryptor.encrypt(phone, encKey, false));
		} else {
			t.setMemberPhone(phone);
		}
		
		return true;
	}
	
	

}
