package com.humuson.tms.batch.step.filter;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Value;

import com.humuson.tms.common.model.target.TargetData;
import com.humuson.tms.common.util.StringUtils;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class ValidationPushChannel implements Validator<TargetData> {
	
	@Setter private String sourceTargetEncryptYn;
	@Setter private String dbEncryptFlag;
	@Value("#{config['tms.db.enc.key']}") private String encKey;
	
	@Override
	public boolean checkValidation(TargetData t, boolean isStrict) {
		if (log.isDebugEnabled()) {
			log.debug("TargetData:{}, isStrict:{}", t.toString(), isStrict);
		}
		if (isStrict 
				&& (
						StringUtils.isNull(t.getDeviceId())
						|| StringUtils.isNull(t.getMemberToken())
					)) {
				return false;
		}
		
		return true;
	}
	
	

}
