package com.humuson.tms.batch.step.filter;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Value;

import com.humuson.tms.common.model.target.TargetData;
import com.humuson.tms.common.security.HumusonDecryptor;
import com.humuson.tms.common.security.HumusonEncryptor;
import com.humuson.tms.common.util.StringUtils;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class ValidationEmailChannel implements Validator<TargetData> {
	
	@Setter private String sourceTargetEncryptYn;
	@Setter private String dbEncryptFlag;
	@Value("#{config['tms.db.enc.key']}") private String encKey;
	
	@Override
	public boolean checkValidation(TargetData t, boolean isStrict) {
		String email = t.getMemberEmail();
		if ("Y".equals(sourceTargetEncryptYn)) {
			try {
				email = HumusonDecryptor.decrypt(email, encKey, false);
			} catch (Exception e) {
				email = null;
				log.error("decrypt error", e);
			}
		}
		
		if (isStrict && StringUtils.isEmailError(email)) {
			return false;
		} 
		
		t.setDomain(StringUtils.getDomain(email));
		
		if ("Y".equals(dbEncryptFlag)) {
			t.setMemberEmail(HumusonEncryptor.encrypt(email, encKey, false));
		} else {
			t.setMemberEmail(email);
		}
		
		return true;
	}
}
