package com.humuson.tms.batch.service.impl;

import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.humuson.tms.batch.domain.BaseResult;
import com.humuson.tms.batch.domain.ChannelSendType;
import com.humuson.tms.batch.service.UpdateResultService;
import com.humuson.tms.constrants.ChannelType;

import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class UpdateResultServiceImpl implements UpdateResultService {
	
	@Autowired protected NamedParameterJdbcTemplate namedParameterJdbcTemplate;
	
	@Override
	public int updateCheckFlag(String updateSql, BaseResult result) {
		SqlParameterSource[] params = SqlParameterSourceUtils.createBatch(new Object[]{result});
		return namedParameterJdbcTemplate.update(updateSql, params[0]);
	}
	
	//@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = { Throwable.class })
	@Override
	public int[] updateCheckFlag(String updateSql, BaseResult[] results) throws Exception {
		SqlParameterSource[] params = SqlParameterSourceUtils.createBatch(results);
		return namedParameterJdbcTemplate.batchUpdate(updateSql, params);
	}
	
	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = { Throwable.class })
	@Override
	public int[] updateList(ChannelType chnType, 
			ChannelSendType chnSendType, 
			String rtnType, String sql,
			SqlParameterSource[] param) throws Exception {
		
		int[] result = null;
		
		result = this.namedParameterJdbcTemplate.batchUpdate(sql, param);
		
		if (log.isDebugEnabled()) {
			log.debug("updateList Size: {}", result.length);
		}
		
		return result;
	}
	
	@Override
	@Transactional(propagation=Propagation.REQUIRES_NEW)
	public int updateStat(String sql,Map<String,Object> statMap) throws Exception {
		return namedParameterJdbcTemplate.update(sql, statMap);
	}
	
	@Override
	public int alreadExistClickInfo(String selectExistClickInfo, BeanPropertySqlParameterSource param) {
		return namedParameterJdbcTemplate.queryForObject(selectExistClickInfo, param, Integer.class);
	}
	
	@Override
	@Transactional(propagation=Propagation.REQUIRES_NEW)
	public int[] updateResponseStat(String updateSql, SqlParameterSource[] params ) throws Exception {
		return namedParameterJdbcTemplate.batchUpdate(updateSql, params);
	}
	
//	@Override
//	public int updateOpenClic2k(String updateSql, BaseResult result) {
//		SqlParameterSource[] params = SqlParameterSourceUtils.createBatch(new Object[]{result});
//		return namedParameterJdbcTemplate.update(updateSql, params[0]);
//	}
}
