package com.humuson.tms.batch.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import com.humuson.tms.batch.service.TargetServerService;

@Slf4j
public class TargetServerServiceImpl implements TargetServerService {

	@Autowired private JdbcTemplate jdbcTemplate;
	@Setter private String selectTargetServerInfo, updateTargetServerInfo, initTargetServerInfo;
	
	@Override
	public List<Properties> getTargetServerList(String postId) {
		
		List<Properties> targetServerList = this.jdbcTemplate.query(selectTargetServerInfo, 
				new RowMapper<Properties>() {
					@Override
					public Properties mapRow(ResultSet rs, int rowNum)
							throws SQLException {
						Properties properties = new Properties();
						properties.put("SERVER_ID", rs.getString("SERVER_ID"));
						properties.put("PARTICIPATION_RATE", rs.getString("PARTICIPATION_RATE"));
						log.info(properties.toString());
						return properties;
					}
		},  postId);
		log.info("targetServerList :{}", targetServerList.toString());
		
		return targetServerList;
	}

	@Override
	public int updateTargetServerInfo(String postId, String serverId, int targetCnt) {
		int uptCnt = jdbcTemplate.update(updateTargetServerInfo, 
				targetCnt, postId, serverId);
		log.info("update TMS_TARGET_SERVER [postId:{}, serverId:{}, count:{}]", 
				postId, serverId, targetCnt);
		return uptCnt;
	}
	
	@Override
	public int updateTargetServerInfo(String postId, Map<String, Integer> serverIdTargetCntMap) {
		int uptCnt = 0;
		Set<String> serverIdSet = serverIdTargetCntMap.keySet();
		for (String targetServerId : serverIdSet) {
			int targetCnt = serverIdTargetCntMap.get(targetServerId);
			uptCnt += updateTargetServerInfo(postId, targetServerId, targetCnt);
		}
		return uptCnt;
	}

	@Override
	public int initTargetServerInfo(String postId) {
		int cnt = jdbcTemplate.update(initTargetServerInfo, postId);
		return cnt;
	}

}
