package com.humuson.tms.batch.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import com.humuson.tms.batch.domain.TargetSchedule;
import com.humuson.tms.batch.service.ScheduleService;
import com.humuson.tms.constrants.ChannelType;

/**
 * @author hyogun
 *
 */

@Slf4j
public class TargetScheduleService implements ScheduleService<TargetSchedule> {
	
	ConcurrentHashMap<String, Boolean> runningScheduleMap = new ConcurrentHashMap<String, Boolean>();
	/**
	 * 
	 */
	@Setter
	private String selectSchedule, updateSchedule;
	@Setter 
	private String selectIsCancleCount;
	
	
	@Autowired
	private JdbcTemplate jdbcTemplate;
	
	@Override
	public boolean isRunning(String key) {
		Boolean isRun = runningScheduleMap.get(key);
		if (isRun == null)
			return false;
		else 
			return isRun;
	}

	@Override
	public void setRunning(String id, boolean isRun) {
		runningScheduleMap.put(id, isRun);
	}
	

	@Override
	public List<TargetSchedule> getScheduleList(Object[] params) {
		return this.jdbcTemplate.query(this.selectSchedule, 
				new RowMapper<TargetSchedule>() {

					@Override
					public TargetSchedule mapRow(ResultSet rs, int rowNum)
							throws SQLException {
						TargetSchedule schedule = new TargetSchedule();
						schedule.setPostId(rs.getString(TargetSchedule.POST_ID));
						schedule.setChannelType(ChannelType.valueOfCode(rs.getString(TargetSchedule.CHN_TYPE)));
						schedule.setTargetType(rs.getString(TargetSchedule.TARGET_TYPE));
						schedule.setMsgId(rs.getString(TargetSchedule.MSG_ID));
						schedule.setDeduplicationYn(rs.getString(TargetSchedule.DEDUPLICATION_YN));
						if (log.isDebugEnabled()) 
							log.debug("target schedule : {}", schedule.toString());
						return schedule;
					}
			
		}, params);
	}

	@Override
	public int updateScheduleStatus(String msgId, String status) {
		int cnt = this.jdbcTemplate.update(this.updateSchedule, status, msgId);
		log.info("update schedule status [msgId:{}, status:{}, uptCnt:{}]", msgId, status, cnt);
		return cnt;
	}

	@Override
	public List<TargetSchedule> getScheduleList() {
		return this.getScheduleList(new Object[]{});
	}

	@Override
	public boolean isCanceled(String key) {
		int count = this.jdbcTemplate.queryForObject(selectIsCancleCount,  new Object[]{key}, Integer.class);
		if (count > 0) return true;
		return false;
	}


}
