package com.humuson.tms.batch.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import com.humuson.tms.batch.domain.PushUpdateSchedule;
import com.humuson.tms.batch.service.ScheduleService;

/**
 * @author hyogun
 *
 */

@Slf4j
public class SmsUpdateScheduleService implements ScheduleService<PushUpdateSchedule> {
	
	ConcurrentHashMap<String, Boolean> runningScheduleMap = new ConcurrentHashMap<String, Boolean>();
	/**
	 * 
	 */
	@Setter private String selectSchedule;
	@Setter private String updateSchedule;
	
	@Autowired
	private JdbcTemplate jdbcTemplate;
	
	@Override
	public boolean isRunning(String key) {
		Boolean isRun = runningScheduleMap.get(key);
		if (isRun == null)
			return false;
		else 
			return isRun;
	}

	@Override
	public void setRunning(String id, boolean isRun) {
		runningScheduleMap.put(id, isRun);
	}
	

	@Override
	public List<PushUpdateSchedule> getScheduleList(Object[] params) {
		List<PushUpdateSchedule> list = this.jdbcTemplate.query(this.selectSchedule, 
				new RowMapper<PushUpdateSchedule>() {

					@Override
					public PushUpdateSchedule mapRow(ResultSet rs, int rowNum)
							throws SQLException {
						PushUpdateSchedule schedule = new PushUpdateSchedule();
						schedule.setMaxId(rs.getLong(PushUpdateSchedule.MAX_ID));
						schedule.setMinId(rs.getLong(PushUpdateSchedule.MIN_ID));
						return schedule;
					}
		}, params);

		return list;
	}

	@Override
	public int updateScheduleStatus(String key, String status) {
		log.info("updateScheduleStatus [key:{}, status:{}]", key, status);
		return 0;
	}

	@Override
	public List<PushUpdateSchedule> getScheduleList() {
		return this.getScheduleList(new Object[]{});
	}

	@Override
	public boolean isCanceled(String key) {
		return false;
	}

}
