package com.humuson.tms.batch.service.impl;

import lombok.Setter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.humuson.tms.batch.service.SendListService;

/**
 * 
 * @author hyogun
 *
 */
public class SendListServiceImpl implements SendListService{
	
	@Setter private String insertSendList;
	@Setter private String insertTempSendList;
	@Autowired private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
	
	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = { Throwable.class })
	@Override
	public int insertSendList(SqlParameterSource[] params) throws DataAccessException {
		int[] result = namedParameterJdbcTemplate.batchUpdate(insertSendList, params);
		return result.length;
	}
	
//	@Transactional(propagation = Propagation.REQUIRED, rollbackFor = { Throwable.class })
	@Override
	public int insertSendList(SqlParameterSource param) throws DataAccessException {
		return namedParameterJdbcTemplate.update(insertSendList, param);
	}
	
	@Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = { Throwable.class })
	@Override
	public void insertSendTempList(SqlParameterSource[] params) throws DataAccessException {
		namedParameterJdbcTemplate.batchUpdate(insertTempSendList, params);
	}	
	
//	@Transactional(propagation = Propagation.REQUIRED, rollbackFor = { Throwable.class })
	@Override
	public void insertSendTempList(SqlParameterSource param) throws DataAccessException {
		namedParameterJdbcTemplate.update(insertTempSendList, param);
	}
	

}
