package com.humuson.tms.batch.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import com.humuson.tms.batch.domain.PushSendSchedule;
import com.humuson.tms.batch.service.ScheduleService;

/**
 * @author hyogun
 *
 */

@Slf4j
public class PushSendScheduleService implements ScheduleService<PushSendSchedule> {
	
	ConcurrentHashMap<String, Boolean> runningScheduleMap = new ConcurrentHashMap<String, Boolean>();
	/**
	 * 
	 */
	@Setter
	private String selectSchedule, updateSchedule;
	
	@Autowired
	private JdbcTemplate jdbcTemplate;
	
	@Override
	public boolean isRunning(String key) {
		Boolean isRun = runningScheduleMap.get(key);
		if (isRun == null)
			return false;
		else 
			return isRun;
	}

	@Override
	public void setRunning(String id, boolean isRun) {
		runningScheduleMap.put(id, isRun);
	}
	

	@Override
	public List<PushSendSchedule> getScheduleList(Object[] params) {
		List<PushSendSchedule> list = this.jdbcTemplate.query(this.selectSchedule, 
				new RowMapper<PushSendSchedule>() {

					@Override
					public PushSendSchedule mapRow(ResultSet rs, int rowNum)
							throws SQLException {
						PushSendSchedule schedule = new PushSendSchedule();
						schedule.setAppGrpKey(rs.getString(PushSendSchedule.APP_GRP_KEY));
						return schedule;
					}
			
		}, params);
		return list;
	}

	@Override
	public int updateScheduleStatus(String key, String status) {
		log.info("updateScheduleStatus [key:{}, status:{}]", key, status);
//		if (StrigUtil.isNupdateSchedule)
//		int cnt = this.jdbcTemplate.update(this.updateSchedule, status, key);
//		log.info("update schedule status [key:{}, status:{}, uptCnt:{}]", key, status, cnt);
		return 0;
	}

	@Override
	public List<PushSendSchedule> getScheduleList() {
		return this.getScheduleList(new Object[]{});
	}

	@Override
	public boolean isCanceled(String key) {
		return false;
	}

}
